/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManager;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManagerProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.tools.internal.DITAMapExtractorUtil;
import com.oxygenxml.positron.core.tools.internal.StructureNode;
import com.oxygenxml.positron.core.tools.internal.StructureNodeFactory;
import com.oxygenxml.positron.core.tools.internal.TreeAccessProvider;
import com.oxygenxml.positron.core.tools.internal.exceptions.CannotComputeDitamapContextException;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.functions.parameters.ExtractDitamapContextParams;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import javax.swing.tree.TreeModel;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.ditamap.WSDITAMapEditorPage;

public class DITAMapHierarchyOverviewProvider {
    private final PluginWorkspace pluginWS;
    private static final String NO_DITAMAP_MESSAGE = "No ditamap is opened in DITA Maps Manager view.";
    private StructureNodeFactory nodesFactory;
    private ExtractDitamapContextParams extractDitamapParams;

    public DITAMapHierarchyOverviewProvider(PluginWorkspace pluginWS, ExtractDitamapContextParams params) {
        this.pluginWS = pluginWS;
        this.extractDitamapParams = params;
    }

    public String getHierarchy() throws JsonProcessingException, MalformedURLException, CannotComputeDitamapContextException {
        StringBuilder response = new StringBuilder();
        WSEditor currentDMMEditorAccess = this.pluginWS.getCurrentEditorAccess(1);
        if (currentDMMEditorAccess != null) {
            URL editorLocation;
            AiIgnoreManager aiIgnoreChecker;
            if (AiIgnoreManagerProvider.getAiIgnoreChecker() != null && (aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker()).isIgnoredFromAiIgnoreFile(editorLocation = currentDMMEditorAccess.getEditorLocation())) {
                return MessageFormat.format(Translator.getInstance().getTranslation("Access_denied_to_File_is_not_AI_accessible"), URLUtil.filterPasswords((String)editorLocation.toExternalForm()));
            }
        } else {
            throw new CannotComputeDitamapContextException(NO_DITAMAP_MESSAGE);
        }
        this.computeContextForCurrentTopic(response, currentDMMEditorAccess);
        return response.toString();
    }

    private void computeContextForCurrentTopic(StringBuilder response, WSEditor currentDMMEditorAccess) throws JsonProcessingException, MalformedURLException, CannotComputeDitamapContextException {
        WSDITAMapEditorPage dmmEditorPage = (WSDITAMapEditorPage)currentDMMEditorAccess.getCurrentPage();
        Object ditamapTree = dmmEditorPage.getDITAMapTreeComponent();
        this.nodesFactory = new StructureNodeFactory(ditamapTree);
        StructureNode currentNodeStructure = null;
        currentNodeStructure = DITAMapExtractorUtil.extractStructureFromDITAMap(this.extractDitamapParams.topicURL, ditamapTree, this.extractDitamapParams.maxDepth, this.extractDitamapParams.isIncludeDescendants());
        if (currentNodeStructure != null) {
            this.appendResourcesOutline(response, currentNodeStructure, TreeAccessProvider.getTreeAccess().getTreeModel(ditamapTree));
        } else {
            response.append(NO_DITAMAP_MESSAGE);
        }
    }

    private void appendResourcesOutline(StringBuilder response, StructureNode selectedNodeStructure, TreeModel model) throws JsonProcessingException {
        Deque<AuthorNode> ancestorNodes = this.getAncestorNodes(selectedNodeStructure);
        AuthorNode selectedNode = selectedNodeStructure.getNode();
        AuthorNode parentNode = TreeAccessProvider.getTreeAccess().getParentNode(this.nodesFactory.getDitamapTree(), selectedNode);
        AuthorNode grandParentNode = TreeAccessProvider.getTreeAccess().getParentNode(this.nodesFactory.getDitamapTree(), parentNode);
        AuthorNode currentNode = null;
        StructureNode lastDescendantNode = null;
        StructureNode root = null;
        while (!ancestorNodes.isEmpty()) {
            currentNode = ancestorNodes.pop();
            StructureNode nodeStructure = this.nodesFactory.createStructureNode(currentNode);
            if (TextUtils.isNullOrBlank(nodeStructure.getName())) continue;
            if (Objects.equals(currentNode, selectedNode) && (!this.extractDitamapParams.includeDescendants || this.extractDitamapParams.maxDepth == 0)) {
                nodeStructure.setNonExpandedChildren(model.getChildCount(selectedNode));
            } else if (grandParentNode != null && !Objects.equals(currentNode, grandParentNode)) {
                nodeStructure.setNonExpandedChildren(Math.max(0, model.getChildCount(currentNode) - 1));
            }
            if (root == null) {
                lastDescendantNode = root = nodeStructure;
                continue;
            }
            lastDescendantNode.addChild(nodeStructure);
            lastDescendantNode = nodeStructure;
        }
        if (grandParentNode != null) {
            if (root == null) {
                lastDescendantNode = root = this.nodesFactory.createStructureNode(grandParentNode);
            }
            lastDescendantNode = this.appendGrandParentNodeChildren(model, parentNode, grandParentNode, lastDescendantNode);
        }
        if (lastDescendantNode == null && parentNode != null) {
            lastDescendantNode = root = this.nodesFactory.createStructureNode(parentNode);
        }
        selectedNodeStructure.setCurrent(true);
        if (lastDescendantNode != null) {
            this.appendCurrentNodeAndSiblings(model, selectedNode, parentNode, lastDescendantNode, selectedNodeStructure);
        } else {
            root = selectedNodeStructure;
        }
        response.append(root != null ? new ObjectMapper().writeValueAsString((Object)root) : NO_DITAMAP_MESSAGE);
    }

    private Deque<AuthorNode> getAncestorNodes(StructureNode selectedNodeStructure) {
        ArrayDeque<AuthorNode> ancestorNodes = new ArrayDeque<AuthorNode>();
        AuthorNode currentNode = selectedNodeStructure.getNode().getParent();
        while (currentNode != null) {
            if ((currentNode = DITAMapExtractorUtil.getParent(currentNode)) == null || TreeAccessProvider.getTreeAccess().getTextForNode(currentNode, this.nodesFactory.getDitamapTree()) == null) continue;
            ancestorNodes.addFirst(currentNode);
        }
        return ancestorNodes;
    }

    private void appendCurrentNodeAndSiblings(TreeModel model, AuthorNode selectedNode, AuthorNode parentNode, StructureNode lastDescendantNode, StructureNode currentStructuredNode) {
        ArrayList<AuthorNode> currentNodeWithSiblings = new ArrayList<AuthorNode>();
        currentNodeWithSiblings.addAll(DITAMapExtractorUtil.getNodeChildren(model, parentNode));
        this.appendNodeAndSiblings(selectedNode, lastDescendantNode, currentStructuredNode, currentNodeWithSiblings);
    }

    private void appendNodeAndSiblings(AuthorNode selectedNode, StructureNode lastDescendantNode, StructureNode currentStructuredNode, List<AuthorNode> currentNodeWithSiblings) {
        for (AuthorNode node : currentNodeWithSiblings) {
            if (selectedNode == node) {
                lastDescendantNode.addChild(currentStructuredNode);
                continue;
            }
            StructureNode nodeLocal = this.nodesFactory.createStructureNode(node);
            nodeLocal.setNonExpandedChildren(TreeAccessProvider.getTreeAccess().getTreeModel(this.nodesFactory.getDitamapTree()).getChildCount(node));
            if (TextUtils.isNullOrBlank(nodeLocal.getName())) continue;
            lastDescendantNode.addChild(nodeLocal);
        }
    }

    private StructureNode appendGrandParentNodeChildren(TreeModel model, AuthorNode parentNode, AuthorNode grandParentNode, StructureNode lastDescendantNode) {
        StructureNode parentStructureNode = this.nodesFactory.createStructureNode(parentNode);
        ArrayList<AuthorNode> currentParentAndUncles = new ArrayList<AuthorNode>();
        currentParentAndUncles.addAll(DITAMapExtractorUtil.getNodeChildren(model, grandParentNode));
        this.appendNodeAndSiblings(parentNode, lastDescendantNode, parentStructureNode, currentParentAndUncles);
        return parentStructureNode;
    }
}

