/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.RAGFunctionExecutorUtil;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.RAGException;
import com.oxygenxml.positron.utilities.functions.SearchInProjectFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.SearchParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchInProjectFunctionExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(SearchInProjectFunctionExecutor.class);
    private SearchInProjectFunctionSignature functionDef = new SearchInProjectFunctionSignature();

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        SearchParams searchParams;
        if (log.isDebugEnabled()) {
            log.debug("Get overview of related project resources: " + arguments);
        }
        if ((searchParams = (SearchParams)arguments) != null) {
            String textToFind = searchParams.textToFind;
            boolean regexp = searchParams.regexp;
            boolean caseSensitive = searchParams.caseSensitive;
            log.debug("Text to find {} regexp {} case sensitive {}", new Object[]{textToFind, regexp, caseSensitive});
            if (textToFind != null) {
                try {
                    String matches = FunctionsAndRAGHelperProvider.getProjectRAGHelper().searchInProject(searchParams);
                    if (log.isDebugEnabled()) {
                        log.debug("Expand to: " + matches);
                    }
                    return matches;
                }
                catch (RAGException e) {
                    throw RAGFunctionExecutorUtil.translateProjectRAGException(e);
                }
            }
        }
        return null;
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ONLY_LAST_CALL;
    }
}

