/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.aiignore.AiIgnoreManager;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManagerProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.ResolveReferenceFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.XMLElement;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.URLInfo;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.dita.ContextKeyManager;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.reference.keyref.KeyInfo;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.node.AuthorDocumentProvider;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;

public class ResolveReferenceFunctionExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(ResolveReferenceFunctionExecutor.class);
    private static final String COULD_NOT_EXPAND_REF = "Could not expand reference";
    private static final String COULD_NOT_FIND_REF_ATTR = "Could not find reference attribute";
    private static final String PARAM_NOT_PROPERLY_PASSED = "XML element content was not properly passed to function";
    private static final String CLASS_ATTR_NAME = "class";
    private static final String KEYREF_ATTR_NAME = "keyref";
    private static final String CONKEYREF_ATTR_NAME = "conkeyref";
    private static final String CONREF_ATTR_NAME = "conref";
    private ResolveReferenceFunctionSignature functionDef = new ResolveReferenceFunctionSignature();
    private static final String DITA_TOPIC_PREFIX = "<!DOCTYPE topic PUBLIC \"-//OASIS//DTD DITA Topic//EN\" \"topic.dtd\">\n<topic id=\"topicId\">\n<body>";
    private static final String DITA_TOPIC_SUFFIX = "</body>\n</topic>";

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        Object toRet;
        block8: {
            if (log.isDebugEnabled()) {
                log.debug("Resolve references: " + arguments);
            }
            toRet = null;
            XMLElement elem = (XMLElement)arguments;
            if (elem != null && elem.xmlElement != null) {
                String elemContent = elem.xmlElement;
                if (log.isDebugEnabled()) {
                    log.debug("Resolve references for XML element: " + elemContent);
                }
                try {
                    URL editorLocation;
                    PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
                    WSEditor currentEditor = pw.getCurrentEditorAccess(0);
                    AiIgnoreManager aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker();
                    if (currentEditor != null && aiIgnoreChecker != null && aiIgnoreChecker.isIgnoredFromAiIgnoreFile(editorLocation = currentEditor.getEditorLocation())) {
                        return MessageFormat.format(Translator.getInstance().getTranslation("Access_denied_to_File_is_not_AI_accessible"), URLUtil.filterPasswords((String)editorLocation.toExternalForm()));
                    }
                    AuthorDocumentProvider docProvider = PluginWorkspaceProvider.getPluginWorkspace().createAuthorDocumentProvider(currentEditor != null ? currentEditor.getEditorLocation() : null, (Reader)new StringReader(ResolveReferenceFunctionExecutor.createTopicContent(elemContent)), true);
                    AuthorDocumentController docController = docProvider.getAuthorDocumentController();
                    AuthorElement rootElement = docController.getAuthorDocumentNode().getRootElement();
                    AuthorElement body = (AuthorElement)rootElement.getContentNodes().get(0);
                    List bodyChildren = body.getContentNodes();
                    if (!bodyChildren.isEmpty()) {
                        AuthorNode refChild = (AuthorNode)bodyChildren.get(0);
                        toRet = refChild instanceof AuthorElement ? ResolveReferenceFunctionExecutor.expandContentOfElement(docController, refChild) : PARAM_NOT_PROPERLY_PASSED;
                        break block8;
                    }
                    toRet = PARAM_NOT_PROPERLY_PASSED;
                }
                catch (IOException | BadLocationException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    toRet = "Could not resolve reference because:" + e.getMessage();
                }
            } else {
                toRet = PARAM_NOT_PROPERLY_PASSED;
            }
        }
        return toRet;
    }

    static String createTopicContent(String elemContent) {
        return DITA_TOPIC_PREFIX + elemContent + DITA_TOPIC_SUFFIX;
    }

    private static String expandContentOfElement(AuthorDocumentController docController, AuthorNode refChild) throws BadLocationException {
        String toRet = COULD_NOT_FIND_REF_ATTR;
        AuthorElement refElement = (AuthorElement)refChild;
        if (ResolveReferenceFunctionExecutor.hasContentReference(refElement)) {
            toRet = ResolveReferenceFunctionExecutor.expandConref(docController, refElement);
        } else if (ResolveReferenceFunctionExecutor.hasKeyReference(refElement)) {
            toRet = ResolveReferenceFunctionExecutor.expandKeyref(refElement);
        }
        return toRet;
    }

    private static boolean hasContentReference(AuthorElement element) {
        return element.getAttribute(CONREF_ATTR_NAME) != null || element.getAttribute(CONKEYREF_ATTR_NAME) != null;
    }

    private static boolean hasKeyReference(AuthorElement element) {
        return element.getAttribute(KEYREF_ATTR_NAME) != null && element.getAttribute(CLASS_ATTR_NAME) != null;
    }

    private static String expandConref(AuthorDocumentController docController, AuthorElement refElement) throws BadLocationException {
        String response = COULD_NOT_EXPAND_REF;
        List refNodes = refElement.getContentNodes();
        if (!refNodes.isEmpty()) {
            AuthorNode referenceNode = (AuthorNode)refNodes.get(0);
            String aiIgnoreResponseForResource = ResolveReferenceFunctionExecutor.getAiIgnoreResponseForResource(referenceNode.getXMLBaseURL());
            if (aiIgnoreResponseForResource != null) {
                response = aiIgnoreResponseForResource;
            } else if (referenceNode instanceof AuthorElement && referenceNode.getStartOffset() + 1 < referenceNode.getEndOffset()) {
                response = docController.serializeFragmentToXML(docController.createDocumentFragment(referenceNode.getStartOffset() + 1, referenceNode.getEndOffset() - 1));
            }
        }
        return response;
    }

    private static String expandKeyref(AuthorElement refElement) {
        URL contextURL;
        LinkedHashMap keys;
        KeyInfo keyInfo;
        String toRet = null;
        String keyrefValue = refElement.getAttribute(KEYREF_ATTR_NAME).getValue();
        if (keyrefValue != null && keyrefValue.length() > 0 && (keyInfo = (KeyInfo)(keys = DITAAccess.getKeys((URL)(contextURL = refElement.getXMLBaseURL()), (ContextKeyManager)ContextKeyManager.getDefault())).get(keyrefValue = DITAAccess.rewriteKeyref((LinkedHashMap)DITAAccess.getURLKeyScopeContexts((URL)contextURL, (ContextKeyManager)ContextKeyManager.getDefault()), (LinkedHashMap)keys, (AuthorNode)refElement, (String)keyrefValue))) != null && keyInfo.getMetaContentProvider() != null) {
            toRet = ResolveReferenceFunctionExecutor.resolveContentFromKeyInfo(refElement, keyInfo);
        }
        return toRet != null ? toRet : COULD_NOT_EXPAND_REF;
    }

    private static String resolveContentFromKeyInfo(AuthorElement refElement, KeyInfo keyInfo) {
        String resolvedContent = null;
        URL definitionLocation = ResolveReferenceFunctionExecutor.cleanURL(keyInfo.getDefinitionLocation());
        URL hrefLocation = ResolveReferenceFunctionExecutor.cleanURL(keyInfo.getHrefLocation());
        boolean isKeydefWithHref = !Equaler.verifyEquals((Object)hrefLocation, (Object)definitionLocation);
        String aiIgnoreResponseForKeyDefintionLocation = ResolveReferenceFunctionExecutor.getAiIgnoreResponseForResource(definitionLocation);
        boolean blockedDueToDefintionLocation = aiIgnoreResponseForKeyDefintionLocation != null;
        String aiIgnoreResponseForKeyHrefLocation = null;
        if (!blockedDueToDefintionLocation && isKeydefWithHref) {
            aiIgnoreResponseForKeyHrefLocation = ResolveReferenceFunctionExecutor.getAiIgnoreResponseForResource(hrefLocation);
        }
        if (blockedDueToDefintionLocation) {
            resolvedContent = aiIgnoreResponseForKeyDefintionLocation;
        } else if (aiIgnoreResponseForKeyHrefLocation != null) {
            resolvedContent = aiIgnoreResponseForKeyHrefLocation;
        } else {
            String classValue = refElement.getAttribute(CLASS_ATTR_NAME).getValue();
            resolvedContent = keyInfo.getMetaContentProvider().getContent(classValue);
        }
        return resolvedContent;
    }

    private static URL cleanURL(URL url) {
        try {
            URLInfo urlInfo = new URLInfo(url);
            return urlInfo.getURL(false, false, false);
        }
        catch (MalformedURLException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e, (Throwable)e);
            }
            return url;
        }
    }

    private static String getAiIgnoreResponseForResource(URL resource) {
        boolean ignoredFromAiIgnoreFile;
        AiIgnoreManager aiIgnoreChecker;
        if (resource != null && (aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker()) != null && (ignoredFromAiIgnoreFile = aiIgnoreChecker.isIgnoredFromAiIgnoreFile(resource))) {
            return MessageFormat.format(Translator.getInstance().getTranslation("Access_denied_to_File_is_not_AI_accessible"), URLUtil.filterPasswords((String)resource.toExternalForm()));
        }
        return null;
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.DISCARD_ALL_CALLS;
    }
}

