/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.AddToTocProperties;
import com.oxygenxml.positron.utilities.functions.parameters.DocumentURL;
import com.oxygenxml.positron.utilities.functions.parameters.EditDocumentProperties;
import com.oxygenxml.positron.utilities.functions.parameters.InvokeActionParams;
import com.oxygenxml.positron.utilities.functions.parameters.InvokeXMLRefactorOperationParams;
import com.oxygenxml.positron.utilities.functions.parameters.InvokeXMLRefactorXSLTScriptParams;
import com.oxygenxml.positron.utilities.functions.parameters.ListParams;
import com.oxygenxml.positron.utilities.functions.parameters.Memory;
import com.oxygenxml.positron.utilities.functions.parameters.ProductNames;
import com.oxygenxml.positron.utilities.functions.parameters.SaveDocumentProperties;
import com.oxygenxml.positron.utilities.functions.parameters.SearchKeywords;
import com.oxygenxml.positron.utilities.functions.parameters.SearchParams;
import com.oxygenxml.positron.utilities.functions.parameters.ValidateDocumentProperties;
import com.oxygenxml.positron.utilities.functions.parameters.XMLElement;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;

public class ParamsDescriptionUtil {
    private static final Logger log = LoggerFactory.getLogger(ParamsDescriptionUtil.class);
    private static final String AI_EXPLANATION_PROP = "explanation";

    public static String getUIFunctionCallWithParamsDescription(ChatFunctionSignature signature, String serializeParameters, Function<String, String> actionNameMapper) {
        Object message = null;
        if (signature != null) {
            String descr;
            message = "Calling tool: '" + signature.getName() + "'";
            if (signature.getUIDecriptionForChatMessage() != null && !signature.getUIDecriptionForChatMessage().isEmpty()) {
                message = signature.getUIDecriptionForChatMessage();
            }
            if (!(serializeParameters == null || serializeParameters.isEmpty() || "{}".equals(serializeParameters) || (descr = ParamsDescriptionUtil.getParamsDescription(signature, serializeParameters, actionNameMapper)) == null || descr.isEmpty())) {
                message = (String)message + " " + descr;
            }
        }
        return message;
    }

    public static String getParamsDescription(ChatFunctionSignature functionSignature, String serializeParameters, Function<String, String> actionNameMapper) {
        String paramsDescription = null;
        try {
            Object deserializeArguments = functionSignature.deserializeArguments(serializeParameters);
            if (deserializeArguments != null) {
                paramsDescription = ParamsDescriptionUtil.getParamsDescription(deserializeArguments, actionNameMapper);
            }
        }
        catch (JsonProcessingException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        return paramsDescription;
    }

    private static String getParamsDescription(Object params, Function<String, String> actionNameMapper) {
        Object description = null;
        if (params instanceof SaveDocumentProperties) {
            SaveDocumentProperties fileProperties = (SaveDocumentProperties)params;
            if (fileProperties.url != null) {
                description = "(" + ParamsDescriptionUtil.getURLWithoutPassword(fileProperties.url) + ")";
            }
        } else if (params instanceof EditDocumentProperties) {
            EditDocumentProperties fileProperties = (EditDocumentProperties)params;
            if (fileProperties.url != null) {
                description = "(" + ParamsDescriptionUtil.getURLWithoutPassword(fileProperties.url) + ")";
            }
        } else if (params instanceof XMLElement) {
            XMLElement elem = (XMLElement)params;
            if (elem.xmlElement != null) {
                description = "(" + elem.xmlElement + ")";
            }
        } else if (params instanceof SearchKeywords) {
            SearchKeywords kw = (SearchKeywords)params;
            description = "(" + kw.keywords + ")";
        } else if (params instanceof SearchParams) {
            SearchParams sp = (SearchParams)params;
            description = "(" + sp.textToFind + ")";
        } else if (params instanceof ProductNames) {
            ProductNames productNames = (ProductNames)params;
            description = "(" + productNames.productNames + ")";
        } else if (params instanceof DocumentURL) {
            DocumentURL docURL = (DocumentURL)params;
            if (docURL.docURL != null) {
                description = "(" + ParamsDescriptionUtil.getURLWithoutPassword(docURL.docURL) + ")";
            }
        } else if (params instanceof AddToTocProperties) {
            AddToTocProperties addToTocProperties = (AddToTocProperties)params;
            if (addToTocProperties.ditaMapURL != null) {
                description = "(" + ParamsDescriptionUtil.getURLWithoutPassword(addToTocProperties.ditaMapURL) + ")";
            }
        } else if (params instanceof InvokeActionParams) {
            InvokeActionParams invokeParms = (InvokeActionParams)params;
            description = actionNameMapper != null ? "(" + actionNameMapper.apply(invokeParms.actionId) + ")" : "(" + invokeParms.actionId + ")";
        } else if (params instanceof InvokeXMLRefactorOperationParams) {
            InvokeXMLRefactorOperationParams invokeParms = (InvokeXMLRefactorOperationParams)params;
            description = "(" + invokeParms.operationId + ")";
        } else if (params instanceof InvokeXMLRefactorXSLTScriptParams) {
            description = "";
        } else if (params instanceof ValidateDocumentProperties) {
            ValidateDocumentProperties valParams = (ValidateDocumentProperties)params;
            description = valParams.url != null ? "(" + ParamsDescriptionUtil.getURLWithoutPassword(valParams.url) + ")" : "";
        } else if (params instanceof Memory) {
            description = "(" + ((Memory)params).rule + ")";
        } else if (params instanceof ListParams) {
            description = "(" + ((ListParams)params).folder_path + ")";
        } else if (params instanceof Map) {
            Map paramsMap = (Map)params;
            String kw = ParamsDescriptionUtil.getValueForFirstKey(paramsMap, "keywords", "query", "id", "textToFind");
            if (kw != null) {
                description = "(" + kw + ")";
            }
            if (paramsMap.containsKey(AI_EXPLANATION_PROP)) {
                description = (String)description + "\n" + paramsMap.get(AI_EXPLANATION_PROP);
            }
        }
        description = ParamsDescriptionUtil.addAIProvidedDescription(params, description);
        return description;
    }

    private static String addAIProvidedDescription(Object params, String description) {
        try {
            Field descriptionParam = params.getClass().getDeclaredField(AI_EXPLANATION_PROP);
            if (descriptionParam != null) {
                descriptionParam.setAccessible(true);
                if (description == null) {
                    description = "";
                }
                description = (String)description + "\n" + descriptionParam.get(params);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return description;
    }

    private static String getValueForFirstKey(Map map, String ... keys) {
        for (String key : keys) {
            Object value = map.get(key);
            if (!(value instanceof String)) continue;
            return (String)value;
        }
        return null;
    }

    private static String getURLWithoutPassword(String urlString) {
        if (urlString != null) {
            urlString = URLUtil.correct((String)urlString, (boolean)false);
            try {
                URL url = new URL(urlString);
                url = URLUtil.maskUserInfo((URL)url);
                if (url != null) {
                    urlString = url.toString();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return urlString;
    }
}

