/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.RAGFunctionExecutorUtil;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.ListFilesFunctionSignature;
import com.oxygenxml.positron.utilities.functions.RAGException;
import com.oxygenxml.positron.utilities.functions.parameters.ListParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListFilesFunctionExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(ListFilesFunctionExecutor.class);
    private ListFilesFunctionSignature functionDef = new ListFilesFunctionSignature();

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        ListParams listParams;
        if (log.isDebugEnabled()) {
            log.debug("List files in directory: " + arguments);
        }
        if ((listParams = (ListParams)arguments) != null && listParams.folder_path != null) {
            String folderPath = listParams.folder_path;
            if (log.isDebugEnabled()) {
                log.debug("Folder to list: {}", (Object)folderPath);
            }
            try {
                String result = FunctionsAndRAGHelperProvider.getProjectRAGHelper().listFiles(folderPath);
                if (log.isDebugEnabled()) {
                    log.debug("List result: " + result);
                }
                return result;
            }
            catch (RAGException e) {
                throw RAGFunctionExecutorUtil.translateProjectRAGException(e);
            }
        }
        return null;
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ALL_CALLS;
    }
}

