/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.SaveDocumentFunctionExecutor;
import com.oxygenxml.positron.core.util.MCPUtil;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.InvokeXMLRefactorOperationFunctionSignature;
import com.oxygenxml.positron.utilities.functions.XMLRefactoringHelperProvider;
import com.oxygenxml.positron.utilities.functions.parameters.InvokeXMLRefactorOperationParams;
import com.oxygenxml.positron.utilities.functions.parameters.SaveDocumentProperties;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeXMLRefactorOperationFunctionExecutor
extends SaveDocumentFunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(InvokeXMLRefactorOperationFunctionExecutor.class);
    private InvokeXMLRefactorOperationFunctionSignature functionDef = new InvokeXMLRefactorOperationFunctionSignature(){

        public String getDescription() {
            return MCPUtil.enrichSaveToolDescription(super.getDescription());
        }
    };

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        if (log.isDebugEnabled()) {
            log.debug("Invoke XML refactoring operation: " + arguments);
        }
        Object toRet = null;
        InvokeXMLRefactorOperationParams params = (InvokeXMLRefactorOperationParams)arguments;
        if (params != null && params.operationId != null && params.url != null) {
            try {
                Map<String, String> paramsMap = InvokeXMLRefactorOperationFunctionExecutor.deserializeParamsMap(params);
                String result = this.refactorContent(params, paramsMap);
                SaveDocumentProperties saveProps = new SaveDocumentProperties();
                saveProps.content = result;
                saveProps.url = params.url;
                saveProps.validate = "true";
                toRet = super.execute(toolId, saveProps);
            }
            catch (IOException e) {
                toRet = e.getMessage();
            }
        } else if (params == null) {
            toRet = "No parameters specified.";
        } else if (params.operationId == null) {
            toRet = "No operation ID specified.";
        } else if (params.url == null) {
            toRet = "No document URL specified.";
        }
        return toRet;
    }

    private String refactorContent(InvokeXMLRefactorOperationParams params, Map<String, String> paramsMap) throws IOException {
        String[] result = new String[1];
        URL url = this.convertToURL(params.url);
        if (url == null) {
            throw new MalformedURLException("Could not convert to URL " + params.url);
        }
        XMLRefactoringHelperProvider.getXMLRefactoringHelper().invokeXMLRefactorOperation(Arrays.asList(url).iterator(), t -> params.content, (t, u) -> {
            result[0] = u;
        }, params.operationId, paramsMap);
        return result[0];
    }

    private static Map<String, String> deserializeParamsMap(InvokeXMLRefactorOperationParams params) throws JsonProcessingException {
        String paramsParam = params.params;
        Map<String, String> paramsMap = new HashMap<String, String>();
        if (paramsParam != null && !paramsParam.isEmpty()) {
            paramsMap = (Map)new ObjectMapper().readValue(paramsParam, Map.class);
        }
        return paramsMap;
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }
}

