/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.tools.DocumentAccessFunctionExecutor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.core.util.ContextExtractorUtil;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetTextAroundCaretFunctionSignature;
import java.net.URL;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTextAroundCaretFunctionExecutor
extends DocumentAccessFunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(GetTextAroundCaretFunctionExecutor.class);
    private GetTextAroundCaretFunctionSignature getTextAroundCaretFunctionDef = new GetTextAroundCaretFunctionSignature();

    @Override
    public Object execute(String toolId, Object arguments) {
        DocumentContentInteractor documentContentExtractor = this.getDocumentContentExtractor();
        if (documentContentExtractor == null) {
            log.error("DocumentContentExtractor is not available");
            return "";
        }
        URL editorLocation = documentContentExtractor.getEditorLocation();
        return ContextExtractorUtil.getContentOrAccessDeniedMessage(editorLocation != null ? editorLocation.toExternalForm() : null, () -> {
            try {
                return documentContentExtractor.getContentAroundCaret(6000);
            }
            catch (BadLocationException e) {
                log.error((Throwable)e);
                return null;
            }
        }, true);
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.getTextAroundCaretFunctionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ONLY_LAST_CALL;
    }
}

