/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.tools.DocumentAccessFunctionExecutor;
import com.oxygenxml.positron.core.tools.GetTextAroundCaretFunctionExecutor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.core.util.OutlineComponentsUtil;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetSCHComponentDetailsSignature;
import com.oxygenxml.positron.utilities.functions.IComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSCHComponentDetailsExecutor
extends DocumentAccessFunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(GetSCHComponentDetailsExecutor.class);
    private GetSCHComponentDetailsSignature getSCHComponentDetailsSignature = new GetSCHComponentDetailsSignature();

    @Override
    public Object execute(String toolId, Object arguments) {
        DocumentContentInteractor documentContentExtractor = this.getDocumentContentExtractor();
        if (documentContentExtractor == null) {
            log.error("DocumentContentExtractor is not available");
        }
        if (OutlineComponentsUtil.checkGetComponentsProviderAvailable()) {
            IComponent iComponent = (IComponent)arguments;
            this.fixUpComponent(iComponent);
            try {
                return OutlineComponentsUtil.findComponent(iComponent);
            }
            catch (Exception e) {
                log.debug((Throwable)e);
            }
        }
        GetTextAroundCaretFunctionExecutor functionExecutor = new GetTextAroundCaretFunctionExecutor();
        functionExecutor.setDocumentContentExtractorSupplier(() -> documentContentExtractor);
        return functionExecutor.execute(toolId, null);
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.getSCHComponentDetailsSignature;
    }

    private void fixUpComponent(IComponent iComponent) {
        String name;
        String type = iComponent.getType();
        if (type != null && (type.isEmpty() || type.equals("null"))) {
            iComponent.setType(null);
        }
        if ((name = iComponent.getName()) != null && (name.isEmpty() || name.equals("null"))) {
            iComponent.setName(null);
        }
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ALL_CALLS;
    }
}

