/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.RAGFunctionExecutorUtil;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.GetRelatedProjectResourcesOverviewFunctionSignature;
import com.oxygenxml.positron.utilities.functions.RAGException;
import com.oxygenxml.positron.utilities.functions.parameters.AdvancedSearchKeywords;
import com.oxygenxml.positron.utilities.functions.parameters.SearchKeywords;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRelatedProjectResourcesOverviewFunctionExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(GetRelatedProjectResourcesOverviewFunctionExecutor.class);
    private GetRelatedProjectResourcesOverviewFunctionSignature functionDef = new GetRelatedProjectResourcesOverviewFunctionSignature();

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        SearchKeywords kw;
        if (log.isDebugEnabled()) {
            log.debug("Get overview of related project resources: " + arguments);
        }
        if ((kw = (SearchKeywords)arguments) != null) {
            String keywords = kw.keywords;
            if (log.isDebugEnabled()) {
                log.debug("Key words: " + keywords);
            }
            if (keywords != null) {
                String returnedContent = null;
                try {
                    if (kw instanceof AdvancedSearchKeywords) {
                        returnedContent = FunctionsAndRAGHelperProvider.getProjectRAGHelper().getRelatedProjectResourcesOverview((AdvancedSearchKeywords)kw);
                    } else {
                        StringWriter sw = new StringWriter();
                        List docs = FunctionsAndRAGHelperProvider.getProjectRAGHelper().getRelatedProjectResourcesOverview(keywords);
                        AIRequestUtil.defaultObjectMapper().writeValue((Writer)sw, (Object)docs);
                        returnedContent = sw.toString();
                    }
                }
                catch (RAGException e) {
                    throw RAGFunctionExecutorUtil.translateProjectRAGException(e);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Expand to: " + returnedContent);
                }
                return returnedContent;
            }
        }
        return null;
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ONLY_LAST_CALL;
    }
}

