/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.RAGFunctionExecutorUtil;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.GetRelatedContentFromSpecificFeedbackSiteSignature;
import com.oxygenxml.positron.utilities.functions.RAGException;
import com.oxygenxml.positron.utilities.functions.parameters.OxygenFeedbackSpecificSiteSearchKeywords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRelatedContentFromSpecificFeedbackSiteExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(GetRelatedContentFromSpecificFeedbackSiteExecutor.class);
    private GetRelatedContentFromSpecificFeedbackSiteSignature functionDef = new GetRelatedContentFromSpecificFeedbackSiteSignature();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        if (log.isDebugEnabled()) {
            log.debug("Get related project content: " + arguments);
        }
        String toRet = null;
        OxygenFeedbackSpecificSiteSearchKeywords kw = (OxygenFeedbackSpecificSiteSearchKeywords)arguments;
        if (kw == null) throw new CannotExecuteFunctionException("No webhelp search parameters specified");
        String keywords = kw.keywords;
        String siteToken = kw.oxygenFeedbackSiteToken;
        if (log.isDebugEnabled()) {
            log.debug("Keywords: " + keywords);
        }
        if (siteToken == null) throw new CannotExecuteFunctionException("No site token is specified");
        if (keywords == null) throw new CannotExecuteFunctionException("No keywords are specified");
        try {
            toRet = FunctionsAndRAGHelperProvider.getProjectRAGHelper().getRelatedWebHelpContent(siteToken, keywords);
        }
        catch (RAGException e) {
            if (!log.isDebugEnabled()) throw RAGFunctionExecutorUtil.translateProjectRAGException(e);
            log.debug((Object)e, (Throwable)e);
            throw RAGFunctionExecutorUtil.translateProjectRAGException(e);
        }
        if (!log.isDebugEnabled()) return toRet;
        log.debug("Expand to: " + toRet);
        return toRet;
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ONLY_LAST_CALL;
    }
}

