/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.internal.DITAMapHierarchyOverviewProvider;
import com.oxygenxml.positron.core.tools.internal.exceptions.CannotComputeDitamapContextException;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetDitaMapStructureContextFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.ExtractDitamapContextParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class GetDitaMapStructureContextFunctionExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(GetDitaMapStructureContextFunctionExecutor.class);
    private static final String CANNOT_COMPUTE_TOC_MSG = "There was a problem computing the table of contents structure.";
    private final GetDitaMapStructureContextFunctionSignature functionDef = new GetDitaMapStructureContextFunctionSignature();

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        StringBuilder response = new StringBuilder();
        try {
            PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
            response.append(new DITAMapHierarchyOverviewProvider(pluginWorkspace, (ExtractDitamapContextParams)arguments).getHierarchy());
        }
        catch (CannotComputeDitamapContextException e) {
            log.error((Throwable)e);
            response.append(e.getMessage());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            response.append(CANNOT_COMPUTE_TOC_MSG);
        }
        return response.toString();
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ONLY_LAST_CALL;
    }
}

