/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.tools.DocumentAccessFunctionExecutor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.core.util.ContextExtractorUtil;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetCurrentDocumentMarkedUpFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.ContentParams;
import java.net.URL;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCurrentDocumentMarkedUpFunctionExecutor
extends DocumentAccessFunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(GetCurrentDocumentMarkedUpFunctionExecutor.class);
    private GetCurrentDocumentMarkedUpFunctionSignature getDocumentFunctionDef = new GetCurrentDocumentMarkedUpFunctionSignature();

    @Override
    public Object execute(String toolId, Object arguments) {
        String toRet = null;
        DocumentContentInteractor documentContentExtractor = this.getDocumentContentExtractor();
        if (documentContentExtractor == null) {
            toRet = "No document is opened in the application main editor area.";
        } else {
            URL editorLocation = documentContentExtractor.getEditorLocation();
            toRet = ContextExtractorUtil.getContentOrAccessDeniedMessage(editorLocation != null ? editorLocation.toExternalForm() : null, () -> {
                try {
                    return documentContentExtractor.getEntireDocumentContent(true).getUsableContent();
                }
                catch (BadLocationException e) {
                    log.error((Throwable)e);
                }
                catch (OperationCancelledByAiIgnoreException operationCancelledByAiIgnoreException) {
                    // empty catch block
                }
                return null;
            }, true);
            ContentParams params = (ContentParams)arguments;
            if (params != null && params.lineNumbering) {
                toRet = TextUtils.addLineNumbering(toRet);
            }
        }
        return toRet;
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.getDocumentFunctionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ONLY_LAST_CALL;
    }
}

