/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetCorrespondingKeyReferencesFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.ProductNames;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.dita.ContextKeyManager;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.reference.keyref.KeyInfo;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;

public class GetCorrespondingKeyReferencesFunctionExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(GetCorrespondingKeyReferencesFunctionExecutor.class);
    private static final String TOPIC_PH_CLASS = " topic/ph ";
    private GetCorrespondingKeyReferencesFunctionSignature functionDef = new GetCorrespondingKeyReferencesFunctionSignature();

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        boolean areProdNamesAvailable;
        if (log.isDebugEnabled()) {
            log.debug("Find keyrefs. Arguments: " + arguments);
        }
        String toRet = "{}";
        ProductNames prodNames = (ProductNames)arguments;
        boolean bl = areProdNamesAvailable = prodNames != null && prodNames.getProductNames() != null && !prodNames.getProductNames().isEmpty();
        if (areProdNamesAvailable) {
            PluginWorkspace pluginWS;
            WSEditor currentEditorAccess;
            if (log.isDebugEnabled()) {
                log.debug("Find keyref for product names: " + prodNames.productNames);
            }
            URL contextURL = (currentEditorAccess = (pluginWS = PluginWorkspaceProvider.getPluginWorkspace()).getCurrentEditorAccess(0)) == null ? null : currentEditorAccess.getEditorLocation();
            LinkedHashMap keys = DITAAccess.getKeys((URL)contextURL, (ContextKeyManager)ContextKeyManager.getDefault());
            HashMap<String, String> productNamesToKeyrefs = new HashMap<String, String>();
            if (keys != null) {
                this.collectKeyrefs(prodNames, keys, productNamesToKeyrefs);
            }
            try {
                StringWriter sw = new StringWriter();
                AIRequestUtil.defaultObjectMapper().writeValue((Writer)sw, productNamesToKeyrefs);
                sw.close();
                toRet = sw.toString();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return toRet;
    }

    private void collectKeyrefs(ProductNames prodNames, LinkedHashMap<String, KeyInfo> keys, Map<String, String> productNamesToKeyrefs) {
        for (Map.Entry<String, KeyInfo> entry : keys.entrySet()) {
            int indexOfContent;
            String content;
            KeyInfo keyInfo = entry.getValue();
            if (keyInfo.getMetaContentProvider() == null || (content = keyInfo.getMetaContentProvider().getContent(TOPIC_PH_CLASS)) == null || (indexOfContent = prodNames.productNames.indexOf(content)) == -1) continue;
            productNamesToKeyrefs.put(content, "<ph keyref=\"" + keyInfo.getKeyName() + "\"/>");
            prodNames.productNames.remove(indexOfContent);
        }
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ALL_CALLS;
    }
}

