/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.RAGFunctionExecutorUtil;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FindSimilarReusableComponentsFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.RAGException;
import com.oxygenxml.positron.utilities.functions.parameters.SearchKeywords;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindSimilarReusableComponentsFunctionExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(FindSimilarReusableComponentsFunctionExecutor.class);
    private static final String NO_SIMILAR_REUSABLE_COMPONENTS_FOUND = "No similar reusable components found";
    private FindSimilarReusableComponentsFunctionSignature functionDef = new FindSimilarReusableComponentsFunctionSignature();

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        SearchKeywords kw;
        if (log.isDebugEnabled()) {
            log.debug("Get reusable components from project: " + arguments);
        }
        String toRet = null;
        if (this.functionDef.isEnabled() && (kw = (SearchKeywords)arguments) != null) {
            String keywords = kw.keywords;
            if (log.isDebugEnabled()) {
                log.debug("Keywords: " + keywords);
            }
            if (keywords != null) {
                try {
                    List comps = FunctionsAndRAGHelperProvider.getProjectRAGHelper().getRelatedReusableComponents(keywords);
                    if (comps == null || comps.isEmpty()) {
                        throw new CannotExecuteFunctionException(NO_SIMILAR_REUSABLE_COMPONENTS_FOUND);
                    }
                    StringWriter sw = new StringWriter();
                    AIRequestUtil.defaultObjectMapper().writeValue((Writer)sw, (Object)comps);
                    toRet = sw.toString();
                }
                catch (RAGException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)e, (Throwable)e);
                    }
                    throw RAGFunctionExecutorUtil.translateProjectRAGException(e);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Return reusable components serialized JSON list: " + toRet);
                }
            }
        }
        return toRet;
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ALL_CALLS;
    }
}

