/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.ExternalChatFunctionSignature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalFunctionExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(ExternalFunctionExecutor.class);
    private ExternalChatFunctionSignature chatFunctionSignature;
    private Method executionMethod;
    private Object executionObject;

    public ExternalFunctionExecutor(String name, String description, String uiCallDescription, String parametersSchema, Method executionMethod, Object executionObject) {
        this.executionMethod = executionMethod;
        this.executionObject = executionObject;
        this.chatFunctionSignature = new ExternalChatFunctionSignature(name, description, uiCallDescription, parametersSchema, executionObject);
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.chatFunctionSignature;
    }

    @Override
    public Object executeWithSerializedArguments(String toolId, String serializedArguments) throws CannotExecuteFunctionException {
        return this.execute(toolId, serializedArguments);
    }

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        String stringArgs = null;
        if (arguments != null) {
            if (arguments instanceof String) {
                stringArgs = (String)arguments;
            } else {
                try {
                    stringArgs = AIRequestUtil.defaultObjectMapper().writeValueAsString(arguments);
                }
                catch (JsonProcessingException e) {
                    throw new CannotExecuteFunctionException(e.getMessage());
                }
            }
        }
        return this.executeExternalFunction(stringArgs, this.enrichAppContextParameters(new HashMap<String, Object>()));
    }

    protected Map<String, Object> enrichAppContextParameters(Map<String, Object> appContext) {
        return appContext;
    }

    public Object executeExternalFunction(String arguments, Map<String, Object> appContext) throws CannotExecuteFunctionException {
        try {
            return this.executionMethod.invoke(this.executionObject, arguments, appContext);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalArgumentException) {
                log.debug(e.getCause().getMessage());
                return "ERROR: " + e.getCause().getMessage();
            }
            boolean isFatal = true;
            try {
                Method isFatalMethod = cause.getClass().getMethod("isFatal", new Class[0]);
                if (isFatalMethod != null) {
                    isFatal = (Boolean)isFatalMethod.invoke((Object)cause, new Object[0]);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
            throw new CannotExecuteFunctionException(cause.getMessage(), isFatal);
        }
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ALL_CALLS;
    }
}

