/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.interactions.ContextInfo;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.ContextInfoSession;
import com.oxygenxml.positron.core.tools.DocumentAccessFunctionExecutor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.core.util.ContextExtractorUtil;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.ExpandContextFunctionSignature;
import java.net.URL;
import java.util.Optional;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandContextFunctionExecutor
extends DocumentAccessFunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(ExpandContextFunctionExecutor.class);
    private ExpandContextFunctionSignature signature = new ExpandContextFunctionSignature();

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.signature;
    }

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        String reponse = "No document is opened in the application main editor area.";
        DocumentContentInteractor docInteractor = this.getDocumentContentExtractor();
        if (docInteractor != null) {
            String location = Optional.ofNullable(docInteractor.getEditorLocation()).map(URL::toExternalForm).orElse(null);
            reponse = ContextExtractorUtil.getContentOrAccessDeniedMessage(location, () -> this.extractContent(docInteractor), true);
        }
        return reponse;
    }

    private String extractContent(DocumentContentInteractor docInteractor) {
        String content = null;
        try {
            ContextInfo ctx;
            ContextInfoSession contextInfoSession = this.getContextInfoSession();
            content = contextInfoSession != null ? ((ctx = docInteractor.expandContext(contextInfoSession)) != null ? ctx.getUsableContent() : docInteractor.getContentAroundCaret(6000)) : docInteractor.getContentAroundCaret(6000);
        }
        catch (OperationCancelledByAiIgnoreException | BadLocationException e) {
            log.error((Object)e, (Throwable)e);
        }
        return content;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ONLY_LAST_CALL;
    }
}

