/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.api.connector.dto.CompletionToolCall;
import com.oxygenxml.positron.api.connector.dto.ToolCallResponseMessage;
import com.oxygenxml.positron.core.actions.ActionInteractor;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.ToolsConfirmationInteractor;
import com.oxygenxml.positron.core.tools.ToolsExecutorListener;
import com.oxygenxml.positron.core.tools.UnsafeFunctionInterceptor;
import java.util.List;

public class ChatToolsExecutorListener
implements ToolsExecutorListener,
ToolsConfirmationInteractor {
    private ChatInteractor chatInteractor;
    private boolean stopped = false;
    private ActionInteractor actionInteractor;

    public ChatToolsExecutorListener(ChatInteractor chatInteractor, ActionInteractor actionInteractor) {
        this.chatInteractor = chatInteractor;
        this.actionInteractor = actionInteractor;
    }

    @Override
    public void startingToProcessFunctionCalls(List<CompletionToolCall> functionCalls, String extraInfoToolCall, String model) {
        if (!this.stopped && this.chatInteractor != null) {
            this.chatInteractor.showFunctionsExecutionStarted(functionCalls, extraInfoToolCall, model, this.actionInteractor);
        }
    }

    @Override
    public void startingToExecute(String toolId, String name, String description, String arguments) {
        if (!this.stopped && this.chatInteractor != null) {
            this.chatInteractor.showFunctionExecutionStarted(toolId, name, description, arguments, this.actionInteractor);
        }
    }

    @Override
    public void checkExecutionAllowed(String toolId, String name, String description, String arguments, UnsafeFunctionInterceptor interceptor) {
        if (!this.stopped && this.chatInteractor != null) {
            this.chatInteractor.checkExecutionAllowed(toolId, name, description, arguments, interceptor);
        } else if (interceptor != null) {
            interceptor.setAccepted(true);
        }
    }

    @Override
    public void functionExecutionFailed(CannotExecuteFunctionException ex) {
        if (!this.stopped && this.chatInteractor != null) {
            this.chatInteractor.showFunctionExecutionFailed(ex);
        }
    }

    @Override
    public void functionExecuted(ToolCallResponseMessage toolCallResponseMessage) {
        if (!this.stopped && this.chatInteractor != null) {
            this.chatInteractor.showFunctionExecuted(toolCallResponseMessage);
        }
    }

    @Override
    public void allFunctionsExecuted() {
        if (!this.stopped && this.chatInteractor != null) {
            this.chatInteractor.showAllFunctionsExecuted();
        }
    }

    public void stop() {
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }
}

