/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ChatFunctionRef;
import com.oxygenxml.positron.utilities.json.Parameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class ChatToolsEnhancer {
    private ChatToolsEnhancer() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static boolean shouldEnhanceWithChatTools(AIActionDetails actionDetails, List<Message> messages) {
        boolean result = false;
        if (actionDetails != null && messages != null) {
            boolean isChatAction;
            boolean bl = isChatAction = actionDetails.getId() != null && actionDetails.getId().startsWith("pseudoaction.chat.message.");
            if (!isChatAction && messages.size() >= 2) {
                boolean hasUser = false;
                boolean hasAssistant = false;
                for (Message m : messages) {
                    if (m.getRole() == RoleType.USER) {
                        hasUser = true;
                    } else if (m.getRole() == RoleType.ASSISTANT) {
                        hasAssistant = true;
                    }
                    if (!hasUser || !hasAssistant) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public static AIActionDetails enhanceActionWithChatTools(AIActionDetails originalActionDetails, AIActionDetails chatActionDetails) {
        AIActionDetails result = originalActionDetails;
        if (originalActionDetails != null && chatActionDetails != null && chatActionDetails.getParameters() != null && chatActionDetails.getParameters().getFunctionRefs() != null) {
            try {
                AIActionDetails enhanced = originalActionDetails.clone();
                Parameters params = originalActionDetails.getParameters() == null ? new Parameters() : enhanced.getParameters();
                ArrayList<ChatFunctionRef> existingRefs = params.getFunctionRefs() != null ? new ArrayList<ChatFunctionRef>(params.getFunctionRefs()) : new ArrayList();
                for (ChatFunctionRef chatRef : chatActionDetails.getParameters().getFunctionRefs()) {
                    boolean alreadyExists = existingRefs.stream().anyMatch(ref -> Objects.equals(ref.getRef(), chatRef.getRef()));
                    if (alreadyExists) continue;
                    existingRefs.add(chatRef);
                }
                params.setFunctionRefs(existingRefs);
                enhanced.setParameters(params);
                if (chatActionDetails.getExpandParams() != null) {
                    enhanced.setExpandParams(new ArrayList(chatActionDetails.getExpandParams()));
                }
                result = enhanced;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return result;
    }
}

