/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.ToolsSessionManager;
import com.oxygenxml.positron.core.tools.internal.DITAMapExtractorUtil;
import com.oxygenxml.positron.core.tools.internal.exceptions.AddToTocException;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.functions.AddToDitaMapStructureFunctionSignature;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.AddToTocProperties;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.ditamap.WSDITAMapEditorPage;

public class AddToDitaMapStructureFunctionExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(AddToDitaMapStructureFunctionExecutor.class);
    private static final String ANCHOR_NOT_FOUND = "Anchor node URL not found";
    private static final String DITA_MAP_NOT_EDITABLE = "Could not insert to Dita Map because the submap is not editable";
    private static final String THE_RUNNABLE_WAS_INTERRUPTED = "The runnable was interrupted";
    private static final String COULD_NOT_FIND_DITA_MAP = "Could not find the DITA Map opened in the DITA Maps Manager view. Ask the user to open it.";
    private static final String COULD_NOT_INSERT_TO_DITA_MAP = "Could not insert to Dita Map";
    private static final String ADDED_TO_TOC = "Added to Dita Map structure";
    protected String toolId = null;
    private AddToDitaMapStructureFunctionSignature functionDef = new AddToDitaMapStructureFunctionSignature();

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        this.toolId = toolId;
        if (log.isDebugEnabled()) {
            log.debug("Add to toc: {}", arguments);
        }
        Object operationStatus = ADDED_TO_TOC;
        AddToTocProperties addToTocProperties = (AddToTocProperties)arguments;
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        URL mapURL = null;
        URL anchorURL = null;
        URL addURL = null;
        try {
            mapURL = URLUtil.correct((URL)new URL(addToTocProperties.ditaMapURL));
        }
        catch (MalformedURLException e) {
            log.error("Target URL was malformed: {}", (Throwable)e);
            operationStatus = "Could not add to Dita Map TOC because DITA Map URL is broken: " + addToTocProperties.ditaMapURL;
        }
        if (Objects.equals(ADDED_TO_TOC, operationStatus)) {
            block19: {
                if (addToTocProperties.anchorURL != null) {
                    try {
                        anchorURL = URLUtil.correct((URL)new URL(addToTocProperties.anchorURL));
                    }
                    catch (MalformedURLException e) {
                        if (mapURL == null) break block19;
                        try {
                            anchorURL = new URL(mapURL, URLUtil.correct((String)addToTocProperties.anchorURL, (boolean)false));
                        }
                        catch (MalformedURLException e1) {
                            log.error("Anchor URL was malformed: {}", (Throwable)e);
                            operationStatus = "Could not add to Dita Map TOC because anchor URL is broken: " + addToTocProperties.anchorURL;
                        }
                    }
                }
            }
            try {
                addURL = URLUtil.correct((URL)new URL(addToTocProperties.resourceURL));
            }
            catch (MalformedURLException e) {
                if (anchorURL != null) {
                    try {
                        addURL = new URL(anchorURL, URLUtil.correct((String)addToTocProperties.resourceURL, (boolean)false));
                    }
                    catch (MalformedURLException e1) {
                        log.error("Resource URL was malformed: {}", (Throwable)e);
                        operationStatus = "Could not add to Dita Map TOC because resource URL is broken: " + addToTocProperties.resourceURL;
                    }
                }
                log.error("Resource URL was malformed: {}", (Throwable)e);
                operationStatus = "Could not add to Dita Map TOC because resource URL is broken: " + addToTocProperties.resourceURL;
            }
            if (Objects.equals(ADDED_TO_TOC, operationStatus)) {
                WSEditor editorAccess = this.openAndGetDMMEditorAccess(pluginWorkspace, mapURL);
                if (editorAccess == null) {
                    operationStatus = COULD_NOT_FIND_DITA_MAP;
                } else {
                    try {
                        this.addReferenceToDitamap(anchorURL, addToTocProperties.positionLocation, pluginWorkspace, addURL, editorAccess);
                    }
                    catch (AddToTocException | IOException e) {
                        operationStatus = e.getMessage();
                    }
                }
            }
        }
        return operationStatus;
    }

    private void addReferenceToDitamap(URL anchorURL, String positionLocation, PluginWorkspace pluginWorkspace, URL addURL, WSEditor editorAccess) throws CannotExecuteFunctionException, AddToTocException, IOException {
        try {
            WSDITAMapEditorPage editorPage = (WSDITAMapEditorPage)editorAccess.getCurrentPage();
            AuthorDocumentController documentController = editorPage.getDocumentController();
            AuthorNode searchNode = DITAMapExtractorUtil.getNodeToInsertTopic(editorAccess.getEditorLocation(), anchorURL, editorPage.getDITAMapTreeComponent());
            if (searchNode == null) {
                log.error("Anchor node URL was not found in the Dita map");
                throw new AddToTocException(ANCHOR_NOT_FOUND);
            }
            AuthorNode referenceNode = searchNode;
            String relativeURL = pluginWorkspace.getUtilAccess().makeRelative(referenceNode.getXMLBaseURL(), addURL);
            String referenceToAdd = "<topicref href='" + relativeURL + "'/>";
            String position = Optional.ofNullable(positionLocation).orElse("After");
            if (!documentController.isEditable(referenceNode)) {
                log.error("Dita Map is not editable");
                throw new AddToTocException(DITA_MAP_NOT_EDITABLE);
            }
            String previousContent = this.readEditorContent(editorAccess);
            Exception[] writingExceptions = new Exception[1];
            Runnable insertDitaMapFragment = () -> {
                try {
                    documentController.insertXMLFragment(referenceToAdd, referenceNode, position);
                }
                catch (AuthorOperationException e) {
                    writingExceptions[0] = e;
                }
            };
            this.invokeSynchronously(insertDitaMapFragment);
            if (writingExceptions[0] != null) {
                log.error("Cannot insert to Dita Map: {}", (Throwable)writingExceptions[0]);
                throw new AddToTocException(COULD_NOT_INSERT_TO_DITA_MAP);
            }
            if (ToolsSessionManager.getInstance().isToolsDocumentsChangesSupportAvailable()) {
                String newContent = this.readEditorContent(editorAccess);
                ToolsSessionManager.getInstance().getToolsDocumentsChangesManager().storeChange(this.toolId, editorAccess.getEditorLocation(), newContent, previousContent);
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            log.error("The runnable was interrupted: {}", (Throwable)e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            CannotExecuteFunctionException cannotExecuteFunctionException = new CannotExecuteFunctionException(THE_RUNNABLE_WAS_INTERRUPTED);
            cannotExecuteFunctionException.setFatal(true);
            throw cannotExecuteFunctionException;
        }
    }

    private String readEditorContent(WSEditor editorAccess) throws IOException {
        try (Reader documentReader = editorAccess.createContentReader();){
            String string = Optional.ofNullable(IOUtil.read((Reader)documentReader)).orElse(new StringBuilder("")).toString();
            return string;
        }
    }

    private WSEditor openAndGetDMMEditorAccess(PluginWorkspace pluginWorkspace, URL ditamapURL) {
        WSEditor editorAccess = pluginWorkspace.getEditorAccess(ditamapURL, 1);
        if (editorAccess == null) {
            pluginWorkspace.open(ditamapURL, null, "application/ditamap");
            editorAccess = pluginWorkspace.getEditorAccess(ditamapURL, 1);
        }
        return editorAccess;
    }

    protected void invokeSynchronously(Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
    }

    @Override
    public boolean requireUserConfirmation() {
        return false;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.DISCARD_ALL_CALLS;
    }
}

