/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.service.config;

import com.oxygenxml.positron.core.auth.exceptions.AuthDataExpiredException;
import com.oxygenxml.positron.core.auth.exceptions.InvalidAuthTokenException;
import com.oxygenxml.positron.core.auth.requests.BearerTokenProvider;
import java.io.IOException;
import java.util.Optional;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class PositronAuthenticationInterceptor
implements Interceptor {
    private final BearerTokenProvider tokenProvider;

    public PositronAuthenticationInterceptor(BearerTokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Optional<String> accessToken = this.tokenProvider.getAccessToken();
        if (!accessToken.isPresent()) {
            try {
                this.tokenProvider.refreshAuthentication();
            }
            catch (AuthDataExpiredException e) {
                throw new InvalidAuthTokenException(e);
            }
            accessToken = this.tokenProvider.getAccessToken();
        }
        Request.Builder requestBuilder = chain.request().newBuilder();
        accessToken.ifPresent(t -> requestBuilder.header("Authorization", "Bearer " + t));
        return chain.proceed(requestBuilder.build());
    }
}

