/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.service.config;

import com.oxygenxml.positron.core.auth.exceptions.AuthDataExpiredException;
import com.oxygenxml.positron.core.auth.exceptions.InvalidAuthTokenException;
import com.oxygenxml.positron.core.auth.exceptions.ServerRequestException;
import com.oxygenxml.positron.core.auth.requests.BearerTokenProvider;
import java.io.IOException;
import java.util.Optional;
import lombok.NonNull;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class AccessTokenAuthenticator
implements Authenticator {
    private final BearerTokenProvider tokenProvider;

    public AccessTokenAuthenticator(BearerTokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request authenticate(Route route, Response response) throws IOException {
        boolean shouldGiveUpAccessTokenRefreshing;
        Optional<String> accessToken = this.tokenProvider.getAccessToken();
        boolean bl = shouldGiveUpAccessTokenRefreshing = this.authenticateCount(response) >= 3 || !this.isRequestWithAccessToken(response);
        if (shouldGiveUpAccessTokenRefreshing) {
            return null;
        }
        AccessTokenAuthenticator accessTokenAuthenticator = this;
        synchronized (accessTokenAuthenticator) {
            return this.newRequestWithAccessToken(response.request(), this.refreshAccessToken(accessToken));
        }
    }

    private Optional<String> refreshAccessToken(Optional<String> accessToken) throws ServerRequestException, InvalidAuthTokenException {
        Optional<String> newAccessToken = this.tokenProvider.getAccessToken();
        if (!accessToken.equals(newAccessToken)) {
            return newAccessToken;
        }
        try {
            this.tokenProvider.refreshAuthentication();
        }
        catch (AuthDataExpiredException e) {
            throw new InvalidAuthTokenException(e);
        }
        return this.tokenProvider.getAccessToken();
    }

    private int authenticateCount(Response response) {
        int result = 1;
        while ((response = response.priorResponse()) != null) {
            ++result;
        }
        return result;
    }

    private boolean isRequestWithAccessToken(@NonNull Response response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        String header = response.request().header("Authorization");
        return header != null && header.startsWith("Bearer");
    }

    @NonNull
    private Request newRequestWithAccessToken(@NonNull Request request, @NonNull Optional<String> accessToken) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        Request.Builder newBuilder = request.newBuilder();
        accessToken.ifPresent(t -> newBuilder.header("Authorization", "Bearer " + t));
        return newBuilder.build();
    }
}

