/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.api.connector.dto.SpeechToTextRequest;
import com.oxygenxml.positron.connector.api.HttpClientExtraConfigProvider;
import com.oxygenxml.positron.connector.openai.RequestLoggingInterceptor;
import com.oxygenxml.positron.connector.util.AIServiceUtil;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.api.ExecutableAction;
import com.oxygenxml.positron.core.api.PositronCompletionChunk;
import com.oxygenxml.positron.core.api.PositronCompletionResponse;
import com.oxygenxml.positron.core.api.SSE;
import com.oxygenxml.positron.core.api.UsageReport;
import com.oxygenxml.positron.core.auth.requests.BearerTokenProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.service.PositronAPI;
import com.oxygenxml.positron.core.service.PositronErrorsUtil;
import com.oxygenxml.positron.core.service.PositronServiceUtil;
import com.oxygenxml.positron.core.service.ResponseBodyCallback;
import com.oxygenxml.positron.core.service.config.AccessTokenAuthenticator;
import com.oxygenxml.positron.core.service.config.PositronAuthenticationInterceptor;
import com.oxygenxml.positron.core.service.config.UserAgentInfo;
import com.oxygenxml.positron.core.service.config.UserAgentInterceptor;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableEmitter;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;
import ro.sync.basic.execution.StoppedByUserException;

public class PositronService {
    private static final Logger log = LoggerFactory.getLogger(PositronService.class);
    private static final ObjectMapper OBJ_MAPPER = AIRequestUtil.defaultObjectMapper();
    private PositronAPI api;
    private BearerTokenProvider tokenProvider;
    private HttpClientExtraConfigProvider httpClientExtraConfigProvider;
    private UserAgentInfo userAgentInfo;
    private CannotComputeCompletionDetailsException cannotCreateAPIException;

    public PositronService(String serverUrl, BearerTokenProvider tokenProvider, HttpClientExtraConfigProvider httpClientExtraConfigProvider, UserAgentInfo userAgentInfo) {
        this.tokenProvider = tokenProvider;
        this.httpClientExtraConfigProvider = httpClientExtraConfigProvider;
        this.userAgentInfo = userAgentInfo;
        try {
            Retrofit retrofit = this.createRetrofit(serverUrl, this.createHttpClient(tokenProvider, serverUrl), OBJ_MAPPER);
            this.api = (PositronAPI)retrofit.create(PositronAPI.class);
        }
        catch (RuntimeException ex) {
            this.cannotCreateAPIException = new CannotComputeCompletionDetailsException(ex.getMessage(), ex);
        }
    }

    public UsageReport getUsageReport() throws CannotComputeCompletionDetailsException, StoppedByUserException {
        if (this.cannotCreateAPIException != null) {
            throw this.cannotCreateAPIException;
        }
        return this.getResponse(this.api.requestUsageRaport());
    }

    public PositronCompletionResponse executeAction(ExecutableAction executableAction) throws CannotComputeCompletionDetailsException, StoppedByUserException {
        if (this.cannotCreateAPIException != null) {
            throw this.cannotCreateAPIException;
        }
        return this.getResponse(this.api.executeAction(executableAction));
    }

    public String convertSpeechToText(SpeechToTextRequest request) throws CannotComputeCompletionDetailsException, StoppedByUserException {
        if (this.cannotCreateAPIException != null) {
            throw this.cannotCreateAPIException;
        }
        try {
            return this.getResponse(this.api.convertSpeechToText(request)).string();
        }
        catch (IOException e) {
            throw new CannotComputeCompletionDetailsException(e.getMessage(), e);
        }
    }

    public Flowable<PositronCompletionChunk> executeActionIncremental(ExecutableAction request) throws CannotComputeCompletionDetailsException {
        if (this.cannotCreateAPIException != null) {
            throw this.cannotCreateAPIException;
        }
        request.setStream(true);
        Call<ResponseBody> executeActionIncremental = this.api.executeActionIncremental(request);
        Flowable<PositronCompletionChunk> completionChunkFlow = this.stream(executeActionIncremental, PositronCompletionChunk.class);
        return PositronServiceUtil.handleFinalFlags(completionChunkFlow);
    }

    private <T> T getResponse(Call<T> call) throws CannotComputeCompletionDetailsException, StoppedByUserException {
        try {
            Response response = call.execute();
            if (Thread.currentThread().isInterrupted()) {
                throw new StoppedByUserException();
            }
            if (!response.isSuccessful()) {
                PositronErrorsUtil.throwExceptionForFailedRequest(response, this.tokenProvider);
            }
            return (T)response.body();
        }
        catch (SocketTimeoutException e) {
            log.error(e.getMessage(), (Throwable)e);
            Translator translator = Translator.getInstance();
            String message = translator.getTranslation("Cannot_obtain_ai_response") + " " + translator.getTranslation("Please_try_again");
            throw new CannotComputeCompletionDetailsException(message, e, true);
        }
        catch (IOException | RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new CannotComputeCompletionDetailsException(e.getMessage(), e);
        }
    }

    private <T> Flowable<T> stream(Call<ResponseBody> apiCall, Class<T> cl) {
        return this.stream(apiCall).map(sse -> OBJ_MAPPER.readValue(sse.getData(), cl));
    }

    private Flowable<SSE> stream(Call<ResponseBody> apiCall) {
        return Flowable.create(emitter -> apiCall.enqueue((Callback)new ResponseBodyCallback((FlowableEmitter<SSE>)emitter, this.tokenProvider)), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    private OkHttpClient createHttpClient(BearerTokenProvider tokenProvider, String serviceBaseUrl) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().authenticator((Authenticator)new AccessTokenAuthenticator(tokenProvider)).addInterceptor((Interceptor)new PositronAuthenticationInterceptor(tokenProvider)).addInterceptor((Interceptor)new UserAgentInterceptor(this.userAgentInfo)).connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout((long)AIServiceUtil.getAIClientReadTimeout(), TimeUnit.MILLISECONDS);
        if (log.isDebugEnabled()) {
            builder = builder.addInterceptor((Interceptor)new RequestLoggingInterceptor(log));
        }
        builder = this.httpClientExtraConfigProvider.configureHttpClientAccordingToPreferences(builder, serviceBaseUrl);
        return builder.build();
    }

    private Retrofit createRetrofit(String serviceBaseUrl, OkHttpClient client, ObjectMapper mapper) {
        return new Retrofit.Builder().baseUrl(serviceBaseUrl).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava3CallAdapterFactory.create()).build();
    }
}

