/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.core.ActionInterruptedByEditorDeselectionException;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.InappropriateCompletionException;
import com.oxygenxml.positron.core.IncompleteCompletionException;
import com.oxygenxml.positron.core.RefusalCompletionException;
import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.api.AIError;
import com.oxygenxml.positron.core.auth.exceptions.InvalidAuthTokenException;
import com.oxygenxml.positron.core.auth.exceptions.InvalidRestApiException;
import com.oxygenxml.positron.core.auth.requests.AccountInfoProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.HttpException;
import retrofit2.Response;
import ro.sync.basic.execution.StoppedByUserException;

public final class PositronErrorsUtil {
    private static final Logger log = LoggerFactory.getLogger(PositronErrorsUtil.class);
    private static final ObjectMapper OBJ_MAPPER = AIRequestUtil.defaultObjectMapper();

    public static <T> void throwExceptionForFailedRequest(Response<T> response, AccountInfoProvider accountInfoProvider) throws CannotComputeCompletionDetailsException, IOException {
        HttpException e = new HttpException(response);
        log.debug("Not successfully response! Error code: {}", (Object)e.code());
        ResponseBody errorBody = response.errorBody();
        if (errorBody == null) {
            throw e;
        }
        String errorResponse = errorBody.string();
        log.debug("Not successfully response: {}", (Object)errorResponse);
        PositronErrorsUtil.throwExceptionForFailedRequest(errorResponse, e.code(), accountInfoProvider);
    }

    static void throwExceptionForFailedRequest(String response, int responseCode, AccountInfoProvider accountInfoProvider) throws CannotComputeCompletionDetailsException {
        PositronErrorsUtil.throwExceptionAccordingToResponseCode(responseCode, response, accountInfoProvider);
        PositronErrorsUtil.throwExceptionAccordingToResponseBody(response, responseCode);
    }

    private static void throwExceptionAccordingToResponseCode(int responseCode, String response, AccountInfoProvider accountInfoProvider) throws CannotComputeCompletionDetailsException {
        Translator translator = Translator.getInstance();
        if (PositronErrorsUtil.isAuthDataExpirationResponseCode(responseCode)) {
            InvalidAuthTokenException invalidTokensEx = new InvalidAuthTokenException();
            throw new CannotComputeCompletionDetailsException(invalidTokensEx.getMessage(), invalidTokensEx);
        }
        if (PositronErrorsUtil.isForbiddenResponseCode(responseCode)) {
            if (!accountInfoProvider.isAccountVerified()) {
                String message = MessageFormat.format(translator.getTranslation("Email_not_verified_Check_view"), translator.getTranslation("AI_Assistant"));
                throw new CannotComputeCompletionDetailsException(message);
            }
            String message = MessageFormat.format(translator.getTranslation("Access_to_platform_denied"), translator.getTranslation("AI_Assistant"));
            throw new CannotComputeCompletionDetailsException(message);
        }
        if (PositronErrorsUtil.isInvalidRestAPIResponseCode(responseCode)) {
            InvalidRestApiException invalidRestApiEx = new InvalidRestApiException();
            throw new CannotComputeCompletionDetailsException(invalidRestApiEx.getMessage(), invalidRestApiEx);
        }
        if (PositronErrorsUtil.isTooManyRequestsResponseCode(responseCode)) {
            AIError positronError = PositronErrorsUtil.extractPositronErrorMessage(response);
            Object message = positronError != null && positronError.getErrorMessage().isPresent() ? positronError.getErrorMessage().get() : translator.getTranslation("Cannot_obtain_ai_response") + " " + translator.getTranslation("Please_try_again");
            throw new CannotComputeCompletionDetailsException((String)message, null, true);
        }
    }

    private static void throwExceptionAccordingToResponseBody(String response, int responseCode) throws CannotComputeCompletionDetailsException {
        AIError error = PositronErrorsUtil.extractPositronErrorMessage(response);
        if (error != null && error.getErrorMessage().isPresent()) {
            throw new CannotComputeCompletionDetailsException(error.getErrorMessage().get(), error.getErrorCode().orElse(null));
        }
        String message = MessageFormat.format(Translator.getInstance().getTranslation("service_cannot_be_reached"), "Oxygen AI Positron");
        log.error(message + " " + responseCode + ": " + response);
        throw new CannotComputeCompletionDetailsException(message, null, true);
    }

    private static AIError extractPositronErrorMessage(String responseBody) {
        AIError positronError = null;
        if (responseBody != null && !responseBody.isEmpty()) {
            try {
                positronError = (AIError)OBJ_MAPPER.readValue(responseBody, AIError.class);
            }
            catch (JsonProcessingException e) {
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return positronError;
    }

    public static boolean isTooManyRequestsResponseCode(int responseCode) {
        return responseCode == 429;
    }

    public static boolean isAuthDataExpirationResponseCode(int responseCode) {
        return responseCode == 401;
    }

    private static boolean isForbiddenResponseCode(int responseCode) {
        return responseCode == 403;
    }

    private static boolean isInvalidRestAPIResponseCode(int httpResponseCode) {
        return httpResponseCode == 404 || httpResponseCode == 405 || httpResponseCode == 406;
    }

    public static boolean hasStreamingIncomplete(List<Throwable> exceptions) {
        return exceptions.stream().anyMatch(e -> e instanceof InterruptedException || e instanceof StoppedByUserException || e instanceof IncompleteCompletionException || e instanceof ActionInterruptedByEditorDeselectionException);
    }

    public static boolean hasStreamingCancelled(List<Throwable> exceptions) {
        return exceptions.stream().anyMatch(e -> e instanceof StoppedByUserException);
    }

    public static boolean hasInappropriateCompletion(List<Throwable> exceptions) {
        return exceptions.stream().anyMatch(e -> e instanceof InappropriateCompletionException);
    }

    public static boolean hasRefusalCompletion(List<Throwable> exceptions) {
        return exceptions.stream().anyMatch(e -> e instanceof RefusalCompletionException);
    }

    public static boolean isStoppedByUser(Throwable cause) {
        return cause != null && (cause instanceof StoppedByUserException || PositronErrorsUtil.isStoppedByUser(cause.getCause()));
    }

    public static boolean wasCancelledByAiIgnore(List<Throwable> exceptions) {
        return exceptions.stream().anyMatch(e -> e instanceof OperationCancelledByAiIgnoreException);
    }

    private PositronErrorsUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

