/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.responses.handler;

import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.responses.handler.IResponseFormatHandler;
import com.oxygenxml.positron.core.responses.handler.ResponseFieldType;
import com.oxygenxml.positron.core.responses.handler.StructuredResponseConstants;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class ResponseFormatHandler
implements IResponseFormatHandler {
    private ChatInteractor chatInteractor = null;
    private Deque<String> fieldsStack;

    public ResponseFormatHandler(ChatInteractor chatInteractor) {
        this.chatInteractor = chatInteractor;
        this.fieldsStack = new ArrayDeque<String>();
    }

    @Override
    public void handleFieldContentChunk(String chunk) {
        if (this.fieldsStack.isEmpty()) {
            this.chatInteractor.showAIAssistantChunkMessage(chunk);
        } else {
            String field = this.fieldsStack.peek();
            if (StructuredResponseConstants.RESPONSE_FIELDS.containsKey(field)) {
                ResponseFieldType responseFieldType = StructuredResponseConstants.RESPONSE_FIELDS.get(field);
                if (responseFieldType == ResponseFieldType.CODEBLOCK) {
                    this.chatInteractor.showAIAssistantCodeChunk(field, chunk);
                } else if (responseFieldType == ResponseFieldType.TEXT) {
                    this.chatInteractor.showAIAssistantTextChunk(field, chunk);
                }
            }
        }
    }

    @Override
    public void handleFieldStarted(String field) {
        this.fieldsStack.push(field);
    }

    @Override
    public void handleFieldEnded(String field) {
        this.fieldsStack.pop();
    }

    List<String> getCurrentFields() {
        return new ArrayList<String>(this.fieldsStack);
    }
}

