/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.interactions.textpage;

import java.awt.Color;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextPageHighlighter {
    private static final Logger logger = LoggerFactory.getLogger((String)TextPageHighlighter.class.getName());
    private JTextComponent textComponent;
    private Highlighter highlighter;
    private Object insertionHighlight;
    private CaretListener caretListener = e -> this.removeCurrentHighlight();

    public TextPageHighlighter(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.textComponent.addCaretListener(this.caretListener);
    }

    public void addHighlight(int startOffset, int endOffset) {
        ro.sync.exml.view.graphics.Color oxyColor = ro.sync.exml.view.graphics.Color.COLOR_PASTE_HIGHLIGHT_YELLOW;
        Color highlightColor = new Color(oxyColor.getRed(), oxyColor.getGreen(), oxyColor.getBlue(), oxyColor.getAlpha());
        this.highlighter = this.textComponent.getHighlighter();
        this.removeCurrentHighlight();
        try {
            this.insertionHighlight = this.highlighter.addHighlight(startOffset, endOffset, new DefaultHighlighter.DefaultHighlightPainter(highlightColor));
        }
        catch (BadLocationException e) {
            logger.debug((Object)e, (Throwable)e);
        }
    }

    private void removeCurrentHighlight() {
        if (this.highlighter != null && this.insertionHighlight != null) {
            this.highlighter.removeHighlight(this.insertionHighlight);
        }
    }

    public void cleanUp() {
        this.removeCurrentHighlight();
        this.textComponent.removeCaretListener(this.caretListener);
    }
}

