/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.interactions.authorpage;

import com.oxygenxml.positron.core.aiignore.AiIgnoreManager;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManagerProvider;
import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.interactions.AuthorContextInfo;
import com.oxygenxml.positron.core.interactions.AuthorStylesProvider;
import com.oxygenxml.positron.core.interactions.AuthorStylesProviderOverAuthorPage;
import com.oxygenxml.positron.core.interactions.ContextInfo;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.tools.ContextInfoSession;
import com.oxygenxml.positron.core.util.AuthorSelectionUtil;
import com.oxygenxml.positron.core.util.AuthorTextUtil;
import com.oxygenxml.positron.utilities.json.InputContext;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorSelectionModel;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;

public abstract class PrefixExtractorForAuthorPage
implements DocumentContentInteractor {
    private AuthorTextUtil authorTextUtil;
    private AuthorDocumentController controller;
    private WSAuthorEditorPage authorPage;
    private AuthorSelectionModel selectionModel;
    private static final Logger LOGGER = LoggerFactory.getLogger(PrefixExtractorForAuthorPage.class);

    protected PrefixExtractorForAuthorPage(AuthorDocumentController controller, WSAuthorEditorPage authorEditorPage) {
        this.authorPage = authorEditorPage;
        this.controller = controller;
        this.selectionModel = this.authorPage.getAuthorSelectionModel();
        this.authorTextUtil = this.createAuthorTextUtil(controller, new AuthorStylesProviderOverAuthorPage(authorEditorPage));
    }

    protected AuthorTextUtil createAuthorTextUtil(AuthorDocumentController controller, AuthorStylesProvider stylesProvider) {
        return new AuthorTextUtil(controller, stylesProvider);
    }

    protected String getTextWithNewlinesBetweenBlocks(int endOffset, AuthorNode blockNode) throws BadLocationException {
        return this.getTextWithNewlinesBetweenBlocks(blockNode.getStartOffset(), endOffset);
    }

    public String getTextWithNewlinesBetweenBlocks(int startOffset, int endOffset) throws BadLocationException {
        return this.authorTextUtil.getTextWithNewlinesBetweenBlocks(startOffset, endOffset);
    }

    @Override
    public String computePromptTextFromCaret(int offset) throws BadLocationException {
        return null;
    }

    @Override
    public ContextInfo getCurrentContextInfo(boolean shouldContainMarkup, InputContext inputContext, boolean updateSelectionIfNeeded) throws BadLocationException, OperationCancelledByAiIgnoreException {
        ContentInterval unifiedSelectionIntervals = AuthorSelectionUtil.unifySelectionIntervals(this.selectionModel);
        ContentInterval selectionInterval = this.selectionModel.getSelectionInterval();
        if (unifiedSelectionIntervals != null) {
            selectionInterval = unifiedSelectionIntervals;
            if (updateSelectionIfNeeded) {
                this.selectionModel.setSelection(unifiedSelectionIntervals.getStartOffset(), unifiedSelectionIntervals.getEndOffset());
            }
        }
        int startOffset = selectionInterval.getStartOffset();
        int endOffset = selectionInterval.getEndOffset();
        int[] balancedIndices = this.authorPage.getBalancedSelection(startOffset, endOffset);
        startOffset = balancedIndices[0];
        endOffset = balancedIndices[1];
        if (inputContext == InputContext.DOCUMENT || inputContext == InputContext.AUTO_SELECTION_DOCUMENT && startOffset == endOffset || this.isRootSelected(startOffset, endOffset)) {
            return this.getEntireDocumentContent(shouldContainMarkup);
        }
        PrefixExtractorForAuthorPage.checkAiIgnoreInContext(this.controller, startOffset, endOffset);
        String usableText = null;
        if (shouldContainMarkup) {
            if (startOffset < endOffset) {
                try {
                    usableText = this.serializeXMLFragment(startOffset, endOffset - 1);
                }
                catch (BadLocationException e) {
                    LOGGER.debug((Object)e, (Throwable)e);
                }
            } else {
                usableText = "";
            }
        } else {
            usableText = this.authorTextUtil.getTextWithNewlinesBetweenBlocks(startOffset, endOffset - 1);
        }
        return new AuthorContextInfo(this.controller, usableText, startOffset, endOffset);
    }

    private String serializeXMLFragment(int startOffset, int endOffset) throws BadLocationException {
        AuthorDocumentFragment fragment = this.controller.createDocumentFragment(startOffset, endOffset, true);
        return this.controller.serializeFragmentToXML(fragment);
    }

    private String serializeXMLFragment(AuthorNode node) throws BadLocationException {
        AuthorDocumentFragment fragment = this.controller.createDocumentFragment(node.getStartOffset(), node.getEndOffset(), true);
        return this.controller.serializeFragmentToXML(fragment);
    }

    @Override
    public ContextInfo getEntireDocumentContent(boolean shouldContainMarkup) throws BadLocationException, OperationCancelledByAiIgnoreException {
        AuthorDocument authorDocumentNode = this.controller.getAuthorDocumentNode();
        int startOffset = authorDocumentNode.getStartOffset();
        int endOffset = authorDocumentNode.getEndOffset();
        PrefixExtractorForAuthorPage.checkAiIgnoreInContext(this.controller, startOffset, endOffset);
        String usableText = null;
        if (shouldContainMarkup) {
            Reader contentReader = this.authorPage.getParentEditor().createContentReader();
            try {
                usableText = IOUtil.read((Reader)contentReader).toString();
            }
            catch (IOException e) {
                usableText = this.serializeXMLFragment(startOffset, endOffset);
            }
        } else {
            usableText = this.authorTextUtil.getTextWithNewlinesBetweenBlocks(startOffset, endOffset);
        }
        return new AuthorContextInfo(this.controller, usableText, startOffset, endOffset);
    }

    @Override
    public ContextInfo getCurrentNodeContent(boolean shouldContainMarkup) {
        return null;
    }

    @Override
    public String getContentAroundCaret(int maxNumberOfChars) throws BadLocationException {
        Optional<AuthorNode> contextBlockNode = PrefixExtractorForAuthorPage.getBlockNode(this.authorPage);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current node: {}", contextBlockNode);
        }
        if (contextBlockNode.isEmpty()) {
            return "";
        }
        String toReturn = null;
        if (this.authorPage.hasSelection() && contextBlockNode.get().getStartOffset() == this.authorPage.getSelectionStart() && contextBlockNode.get().getEndOffset() == this.authorPage.getSelectionEnd() - 1) {
            Optional<AuthorNode> leftNode = this.getLeftNode();
            StringBuilder context = new StringBuilder();
            if (leftNode.isPresent()) {
                context.append("#CONTEXT BEFORE SELECTION #\n");
                String leftContent = this.serializeXMLFragment(leftNode.get());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Left content: {}", (Object)leftContent);
                }
                context.append(leftContent);
            }
            if (context.length() > 0) {
                context.append("\n");
            }
            context.append("#CURRENT SELECTION #\n");
            String contextBlockContent = this.serializeXMLFragment(contextBlockNode.get());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Left content: {}", (Object)contextBlockContent);
            }
            context.append(contextBlockContent);
            Optional<AuthorNode> rightNode = this.getRightNode(contextBlockNode.get());
            if (rightNode.isPresent()) {
                String rightContent = this.serializeXMLFragment(rightNode.get());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Right content: {}", (Object)rightContent);
                }
                context.append("\n#CONTEXT AFTER SELECTION #\n");
                context.append(rightContent);
            }
            toReturn = context.toString();
        } else {
            String contextContent = this.serializeXMLFragment(contextBlockNode.get());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Context for caret: {}", (Object)contextContent);
            }
            toReturn = contextContent;
        }
        return toReturn;
    }

    @Override
    public String extractContextWithCaretMarker(int maxNumberOfChars) throws BadLocationException {
        return this.getContentAroundCaret(maxNumberOfChars);
    }

    private Optional<AuthorNode> getRightNode(AuthorNode contextBlockNode) throws BadLocationException {
        AuthorDocumentController ctrl = this.authorPage.getDocumentController();
        int endOffset = ctrl.getAuthorDocumentNode().getEndOffset();
        int offset = contextBlockNode.getEndOffset() + 1;
        OffsetInformation info = ctrl.getContentInformationAtOffset(offset);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Right detection: {} nm: {} n: {}", new Object[]{info.getPositionType(), info.getNodeForMarkerOffset(), info.getNodeForOffset()});
        }
        while (info.getPositionType() != 1 && offset < endOffset) {
            info = ctrl.getContentInformationAtOffset(++offset);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Right detection: {} nm: {} n: {}", new Object[]{info.getPositionType(), info.getNodeForMarkerOffset(), info.getNodeForOffset()});
        }
        return Optional.ofNullable(info.getPositionType() == 1 ? info.getNodeForMarkerOffset() : null);
    }

    private Optional<AuthorNode> getLeftNode() throws BadLocationException {
        AuthorDocumentController ctrl = this.authorPage.getDocumentController();
        int offset = this.authorPage.getSelectionStart() - 1;
        OffsetInformation info = ctrl.getContentInformationAtOffset(offset);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Left detection: {} nm: {} n: {}", new Object[]{info.getPositionType(), info.getNodeForMarkerOffset(), info.getNodeForOffset()});
        }
        while (info.getPositionType() != 2 && offset > 0) {
            info = ctrl.getContentInformationAtOffset(--offset);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Left detection: {} nm: {} n: {}", new Object[]{info.getPositionType(), info.getNodeForMarkerOffset(), info.getNodeForOffset()});
        }
        return Optional.ofNullable(info.getPositionType() == 2 ? info.getNodeForMarkerOffset() : null);
    }

    private static Optional<AuthorNode> getBlockNode(WSAuthorEditorPage authorPage) throws BadLocationException {
        AuthorNode currentNode = authorPage.getFullySelectedNode();
        if (currentNode == null) {
            currentNode = authorPage.getDocumentController().getNodeAtOffset(authorPage.getCaretOffset());
        }
        currentNode = PrefixExtractorForAuthorPage.findFistParentBlockNode(authorPage, currentNode);
        return Optional.ofNullable(currentNode);
    }

    @Override
    public boolean hasSelection() {
        return this.selectionModel.hasSelection();
    }

    @Override
    public void prepareSelectionForReplaceAction(InputContext inputContext) {
        if (!this.hasSelection() && inputContext == InputContext.AUTO_SELECTION_DOCUMENT || inputContext == InputContext.DOCUMENT) {
            AuthorElement rootElement = this.controller.getAuthorDocumentNode().getRootElement();
            this.authorPage.select(rootElement.getStartOffset(), rootElement.getEndOffset() + 1);
        }
    }

    @Override
    public int getCaretOffset() {
        ContentInterval selectionInterval = this.selectionModel.getSelectionInterval();
        return selectionInterval.getEndOffset();
    }

    boolean isRootSelected(int startOffset, int endOffset) {
        AuthorElement rootElement = this.controller.getAuthorDocumentNode().getRootElement();
        return rootElement != null && startOffset <= rootElement.getStartOffset() && rootElement.getEndOffset() <= endOffset;
    }

    @Override
    public URL getEditorLocation() {
        return this.authorPage.getAuthorAccess().getEditorAccess().getEditorLocation();
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void reloadContent(String content, boolean shouldMarkAsClean) throws IOException {
        if (this.authorPage.isEditable()) {
            this.authorPage.getParentEditor().reloadContent((Reader)new StringReader(content), false);
            if (shouldMarkAsClean) {
                this.authorPage.getParentEditor().setModified(false);
            }
        } else {
            throw new IOException("Document is not editable.");
        }
    }

    @Override
    public boolean isConcurrentEditingEnabled() {
        return false;
    }

    private static void checkAiIgnoreInContext(AuthorDocumentController ctrl, int startOffset, int endOffset) throws OperationCancelledByAiIgnoreException {
        block4: {
            AiIgnoreManager aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker();
            if (aiIgnoreChecker != null && startOffset != endOffset) {
                try {
                    AuthorNode commonParentNode = ctrl.getCommonParentNode(ctrl.getAuthorDocumentNode(), startOffset, endOffset);
                    HashSet<String> alreadySafeURLs = new HashSet<String>();
                    if (PrefixExtractorForAuthorPage.isAiIgnored(commonParentNode, startOffset, endOffset, alreadySafeURLs)) {
                        throw new OperationCancelledByAiIgnoreException();
                    }
                }
                catch (BadLocationException e) {
                    if (!LOGGER.isDebugEnabled()) break block4;
                    LOGGER.debug((Object)e, (Throwable)e);
                }
            }
        }
    }

    static boolean isAiIgnored(AuthorNode node, int startOffset, int endOffset, Set<String> alreadySafeURLs) {
        String baseURLString;
        URL baseUrl;
        boolean isNodeIntersectsSelection;
        boolean bl = isNodeIntersectsSelection = startOffset <= node.getEndOffset() && endOffset > node.getStartOffset();
        if (isNodeIntersectsSelection && (baseUrl = node.getXMLBaseURL()) != null && !alreadySafeURLs.contains(baseURLString = baseUrl.toExternalForm())) {
            if (AiIgnoreManagerProvider.getAiIgnoreChecker().isIgnoredFromAiIgnoreFile(baseUrl)) {
                return true;
            }
            alreadySafeURLs.add(baseURLString);
        }
        if (node instanceof AuthorParentNode) {
            AuthorParentNode authorElement = (AuthorParentNode)node;
            for (AuthorNode child : authorElement.getContentNodes()) {
                if (!PrefixExtractorForAuthorPage.isAiIgnored(child, startOffset, endOffset, alreadySafeURLs)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ContextInfo expandContext(ContextInfoSession contextInfoSession) throws BadLocationException, OperationCancelledByAiIgnoreException {
        boolean fistFunctionCallButOriginalContextCouldNotBeExtracted;
        ContextInfo previousContext = contextInfoSession.getPreviouslyUsedContext();
        ContextInfo originalContext = contextInfoSession.getOriginalContext();
        ContextInfo toRet = null;
        boolean fistFunctionCall = previousContext == null && originalContext != null;
        boolean originalContextWasNotEnough = previousContext != null && originalContext.equals(previousContext);
        boolean bl = fistFunctionCallButOriginalContextCouldNotBeExtracted = previousContext == null && originalContext == null;
        toRet = fistFunctionCallButOriginalContextCouldNotBeExtracted ? this.buildContextAtCaret() : (fistFunctionCall || originalContextWasNotEnough ? this.expandCurrentContext(originalContext) : this.expandCurrentContext(previousContext));
        this.authorPage.select(toRet.getStartOffset(), toRet.getEndOffset());
        contextInfoSession.setPreviouslyUsedContext(toRet);
        return toRet;
    }

    private ContextInfo buildContextAtCaret() throws BadLocationException {
        Optional<AuthorNode> blockNode = PrefixExtractorForAuthorPage.getBlockNode(this.authorPage);
        AuthorNode authorNode = blockNode.isPresent() ? blockNode.get() : this.controller.getNodeAtOffset(this.getCaretOffset());
        return new ContextInfo(this.serializeXMLFragment(authorNode), authorNode.getStartOffset(), authorNode.getEndOffset() + 1);
    }

    private ContextInfo expandCurrentContext(ContextInfo startContext) throws BadLocationException {
        AuthorNode parent;
        int endOffset;
        AuthorNode authorNode = null;
        int startOffset = startContext.getStartOffset();
        List nodesToSelect = this.controller.getNodesToSelect(startOffset, endOffset = startContext.getEndOffset());
        if (nodesToSelect.size() > 0) {
            authorNode = (AuthorNode)nodesToSelect.get(0);
        }
        int authorNodeStart = authorNode.getStartOffset();
        int authorNodeEnd = authorNode.getEndOffset();
        if (startOffset == authorNodeStart && authorNodeEnd + 1 == endOffset && (parent = authorNode.getParent()) != null) {
            authorNode = parent;
        }
        authorNode = PrefixExtractorForAuthorPage.findFistParentBlockNode(this.authorPage, authorNode);
        return new ContextInfo(this.serializeXMLFragment(authorNode), authorNode.getStartOffset(), authorNode.getEndOffset() + 1);
    }

    private static AuthorNode findFistParentBlockNode(WSAuthorEditorPage authorPage, AuthorNode currentNode) {
        while (currentNode != null && authorPage.getStyles(currentNode).isInline()) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }
}

