/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.interactions.authorpage;

import com.oxygenxml.positron.core.interactions.authorpage.PrefixExtractorForAuthorPage;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;

public class OpenAIPrefixExtractorForAuthorPage
extends PrefixExtractorForAuthorPage {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)OpenAIPrefixExtractorForAuthorPage.class.getName());

    public OpenAIPrefixExtractorForAuthorPage(AuthorDocumentController controller, WSAuthorEditorPage authorEditorPage) {
        super(controller, authorEditorPage);
    }

    @Override
    public String computeUserInputFromDocument(int offset, int maxNumberOfChars) throws BadLocationException {
        int startOffset = offset - maxNumberOfChars;
        if (startOffset < 0) {
            startOffset = 0;
        }
        String text = this.getTextWithNewlinesBetweenBlocks(startOffset, offset - 1);
        text = OpenAIPrefixExtractorForAuthorPage.fromFirstPunctuationOrSpace(text);
        LOGGER.debug("Prefix: {}", (Object)text);
        return text;
    }

    static String fromFirstPunctuationOrSpace(String text) {
        String ret = text;
        int length = text.length();
        boolean end = false;
        for (int i = 0; i < length && !end; ++i) {
            char ch = text.charAt(i);
            if (Character.isUpperCase(ch)) {
                ret = text.substring(i, length);
                end = true;
                continue;
            }
            if (Character.isLetterOrDigit(ch)) continue;
            ret = text.substring(i + 1, length);
            end = true;
        }
        return ret;
    }
}

