/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.auth.requests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.security.Sandbox;

public class ServerRequestHandlerUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)ServerRequestHandlerUtil.class.getName());

    private ServerRequestHandlerUtil() {
    }

    public static String getResponseFromConnection(final URLConnection conn) throws Exception {
        return ServerRequestHandlerUtil.openServerConnection(new URLConnectionSupplier<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String get() throws IOException {
                StringBuilder response = null;
                if (conn != null) {
                    response = new StringBuilder();
                    BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
                    try {
                        String inputLine = null;
                        while ((inputLine = in.readLine()) != null) {
                            response.append(inputLine);
                            response.append('\n');
                        }
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            logger.warn(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                return response == null ? null : response.toString().trim();
            }
        });
    }

    public static <T> T openServerConnection(URLConnectionSupplier<T> executor) throws Exception {
        return (T)Sandbox.runInSafeConnectContext(executor::get);
    }

    public static interface URLConnectionSupplier<T> {
        public T get() throws Exception;
    }
}

