/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.auth.requests;

import com.oxygenxml.positron.core.auth.requests.EncryptionSupport;
import com.oxygenxml.positron.core.auth.requests.OxygenEncryptionSupport;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

class RefreshTokenStore {
    private static final Logger logger = LoggerFactory.getLogger((String)RefreshTokenStore.class.getName());
    private EncryptionSupport encryptionSupport = new OxygenEncryptionSupport();

    RefreshTokenStore() {
    }

    public Optional<String> getRefreshTokenFromOptions() {
        String encryptedToken = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption("oxygen.positron.plugin.refresh.token", "");
        return Optional.ofNullable(encryptedToken).map(this.encryptionSupport::decrypt);
    }

    public void storeRefreshTokenInOptions(String refreshToken) {
        try {
            PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().setOption("oxygen.positron.plugin.refresh.token", this.encryptionSupport.encrypt(refreshToken));
        }
        catch (Exception e) {
            logger.debug((Object)e, (Throwable)e);
        }
    }

    public void clearRefreshToken() {
        PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().setOption("oxygen.positron.plugin.refresh.token", null);
    }
}

