/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.oxygenxml.positron.api.connector.dto.CompletionChoice;
import com.oxygenxml.positron.api.connector.dto.CompletionMessage;
import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.api.connector.dto.CompletionToolCall;
import java.util.ArrayList;
import java.util.List;

public class CompletionResponseUtil {
    private static final int CHOICE_INDEX = 0;

    private CompletionResponseUtil() {
    }

    public static List<CompletionToolCall> getToolCalls(CompletionResponse response) {
        ArrayList<CompletionToolCall> toolCalls = new ArrayList<CompletionToolCall>();
        if (response != null && response.getChoices() != null) {
            for (CompletionChoice chatCompletionChoice : response.getChoices()) {
                CompletionMessage message;
                if (0 != chatCompletionChoice.getIndex() || (message = chatCompletionChoice.getMessage()) == null || message.getToolCalls() == null) continue;
                toolCalls.addAll(message.getToolCalls());
            }
        }
        return toolCalls;
    }

    public static String getCompletion(CompletionResponse response) {
        String completion = "";
        if (response != null && response.getChoices() != null) {
            for (CompletionChoice chatCompletionChoice : response.getChoices()) {
                if (0 != chatCompletionChoice.getIndex()) continue;
                CompletionMessage message = chatCompletionChoice.getMessage();
                if (message == null) break;
                completion = message.getContent();
                break;
            }
        }
        return completion;
    }

    @JsonIgnore
    public static boolean isFlaggedByModeration(CompletionResponse response) {
        boolean isFlagged = false;
        if (response != null && response.getChoices() != null) {
            for (CompletionChoice completionChoice : response.getChoices()) {
                if (0 != completionChoice.getIndex()) continue;
                String finishReason = completionChoice.getFinishReason();
                if (!"moderationFlagged".equals(finishReason) && !"content_filter".equals(finishReason)) break;
                isFlagged = true;
                break;
            }
        }
        return isFlagged;
    }

    @JsonIgnore
    public static boolean isIncompleteCompletion(CompletionResponse response) {
        boolean isIncomplete = false;
        if (response != null && response.getChoices() != null) {
            for (CompletionChoice completionChoice : response.getChoices()) {
                if (0 != completionChoice.getIndex()) continue;
                String finishReason = completionChoice.getFinishReason();
                if (!"length".equals(finishReason)) break;
                isIncomplete = true;
                break;
            }
        }
        return isIncomplete;
    }

    @JsonIgnore
    public static boolean isRefusalCompletion(CompletionResponse response) {
        boolean isRefusal = false;
        if (response != null && response.getChoices() != null) {
            for (CompletionChoice completionChoice : response.getChoices()) {
                if (0 != completionChoice.getIndex()) continue;
                String finishReason = completionChoice.getFinishReason();
                if (!"refusal".equals(finishReason)) break;
                isRefusal = true;
                break;
            }
        }
        return isRefusal;
    }

    @JsonIgnore
    public static String getFinishReason(CompletionResponse response) {
        String finishReason = null;
        if (response != null && response.getChoices() != null) {
            for (CompletionChoice completionChoice : response.getChoices()) {
                if (0 != completionChoice.getIndex()) continue;
                finishReason = completionChoice.getFinishReason();
                break;
            }
        }
        return finishReason;
    }

    @JsonIgnore
    public static boolean hasToolCalls(CompletionResponse response) {
        boolean hasToolCalls = false;
        if (response != null && response.getChoices() != null) {
            for (CompletionChoice completionChoice : response.getChoices()) {
                if (0 != completionChoice.getIndex()) continue;
                hasToolCalls = completionChoice.getMessage() != null && completionChoice.getMessage().getToolCalls() != null && !completionChoice.getMessage().getToolCalls().isEmpty();
                break;
            }
        }
        return hasToolCalls;
    }
}

