/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.validation;

import com.oxygenxml.positron.connector.util.ReactiveUtil;
import com.oxygenxml.positron.core.actions.validation.AIContentEventListener;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.plugin.OptionConstants;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.core.util.XMLDocumentResponseTypeDetector;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.InvokeActionHelperProvider;
import com.oxygenxml.positron.utilities.functions.ValidateContentHelper;
import com.oxygenxml.positron.utilities.functions.ValidateContentHelperProvider;
import com.oxygenxml.positron.utilities.functions.ValidationReportConfig;
import io.reactivex.rxjava3.core.Flowable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class AutoValidationManager
implements AIContentEventListener {
    private static final Logger logger = LoggerFactory.getLogger(AutoValidationManager.class);
    private final ChatInteractor chatInteractor;
    private final ScheduledExecutorService scheduledExecutorService;
    private static final long VALIDATION_DEBOUNCE_DELAY_MS = 200L;
    private final AtomicReference<Future<?>> currentValidationTask = new AtomicReference();
    private String lastValidationContentId;
    private final int MAX_FAILED_VALIDATIONS = 3;
    private String validationMessageId;

    public AutoValidationManager(ChatInteractor chatInteractor) {
        this.chatInteractor = chatInteractor;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "AutoValidation-Thread");
            thread.setDaemon(true);
            return thread;
        });
    }

    @Override
    public void aiContentApplied(String url, int startOffset, int endOffset, String appliedContent) {
        if (AutoValidationManager.isAutoValidationOnInsertionEnabled()) {
            this.lastValidationContentId = this.chatInteractor.getCurrentMessageContentId();
            this.submitDebouncedValidationTask(() -> this.validateContentRange(URLUtil.convertToURL((String)url), startOffset, endOffset, appliedContent));
        }
    }

    @Override
    public void aiContentApplied(String url) {
        if (AutoValidationManager.isAutoValidationOnInsertionEnabled()) {
            this.lastValidationContentId = this.chatInteractor.getCurrentMessageContentId();
            this.submitDebouncedValidationTask(() -> this.validateEntireContent(URLUtil.convertToURL((String)url), true));
        }
    }

    private void cancelCurrentValidationTask() {
        Future task = this.currentValidationTask.getAndSet(null);
        if (task != null && !task.isDone() && !task.isCancelled()) {
            task.cancel(true);
        }
    }

    private void submitDebouncedValidationTask(Runnable validationRunnable) {
        this.cancelCurrentValidationTask();
        ScheduledFuture<?> task = this.scheduledExecutorService.schedule(() -> {
            try {
                validationRunnable.run();
            }
            finally {
                this.currentValidationTask.compareAndSet(this.currentValidationTask.get(), null);
            }
        }, 200L, TimeUnit.MILLISECONDS);
        this.currentValidationTask.set(task);
    }

    public static boolean isAutoValidationXMLFragmentsEnabled() {
        WSOptionsStorage optionsStorage;
        PluginWorkspace workspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (workspace != null && (optionsStorage = workspace.getOptionsStorage()) != null) {
            return Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.auto.validate.xml.fragments", OptionConstants.AUTO_VALIDATE_XML_FRAGMENT_DEFAULT));
        }
        return true;
    }

    private static boolean isAutoValidationWholeDocEnabled() {
        WSOptionsStorage optionsStorage;
        PluginWorkspace workspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (workspace != null && (optionsStorage = workspace.getOptionsStorage()) != null) {
            return Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.auto.validate.whole.document", OptionConstants.AUTO_VALIDATE_WHOLE_DOCUMENT_DEFAULT));
        }
        return true;
    }

    public static boolean isAutoValidationOnInsertionEnabled() {
        WSOptionsStorage optionsStorage;
        PluginWorkspace workspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (workspace != null && (optionsStorage = workspace.getOptionsStorage()) != null) {
            return Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.auto.validate.insertion", OptionConstants.AUTO_VALIDATE_INSERTION_DEFAULT));
        }
        return true;
    }

    private void validateContentRange(URL url, int startOffset, int endOffset, String appliedContent) {
        ValidateContentHelper validateHelper = ValidateContentHelperProvider.getValidateContentHelper();
        if (validateHelper != null) {
            try {
                String validationResult;
                String content = this.getDocumentContent(url);
                if (content != null && (validationResult = validateHelper.validate(url, content, startOffset, endOffset, ValidationReportConfig.NO_LOCATION_DETAILS)) != null && !validationResult.isEmpty() && !validationResult.equals("[]")) {
                    this.handleValidationProblems(appliedContent, startOffset, endOffset, validationResult, false, null, true);
                }
            }
            catch (IOException e) {
                logger.debug("Error validating content range", (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.debug("Validation task was cancelled", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void validateEntireContent(URL url, boolean isForAppliendContent) {
        try {
            String content = this.getDocumentContent(url);
            if (content != null) {
                this.validateEntireContent(url, content, isForAppliendContent);
            }
        }
        catch (IOException e) {
            logger.error("Error validating entire content", (Throwable)e);
        }
    }

    private void validateEntireContent(URL url, String content, boolean isForAppliendContent) {
        try {
            ValidateContentHelper validateHelper = ValidateContentHelperProvider.getValidateContentHelper();
            if (validateHelper != null) {
                String validationResult;
                if (!isForAppliendContent) {
                    url = this.createNonExistingContextURL(url);
                }
                if ((validationResult = validateHelper.validate(url, content, ValidationReportConfig.NO_RESOURCE_DETAILS)) != null && !validationResult.isEmpty() && !validationResult.equals("[]")) {
                    this.handleValidationProblems(content, 0, content.length(), validationResult, true, url.toString(), isForAppliendContent);
                }
            }
        }
        catch (InterruptedException e) {
            logger.debug("Validation task was cancelled", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private URL createNonExistingContextURL(URL url) {
        String fileName = URLUtil.extractFileName((URL)url);
        if (fileName != null && !fileName.isEmpty()) {
            try {
                URL parentURL = URLUtil.getParentURL((URL)url);
                if (parentURL != null) {
                    String fileNameNoExt = URLUtil.removeExtension((String)fileName);
                    String ext = URLUtil.getExtension((String)fileName);
                    Object newFileName = fileNameNoExt;
                    newFileName = (String)newFileName + "-ai-validation";
                    if (ext != null && !ext.isEmpty()) {
                        newFileName = (String)newFileName + "." + ext;
                    }
                    url = new URL(parentURL, (String)newFileName);
                }
            }
            catch (MalformedURLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return url;
    }

    private boolean canShowValidationReport() {
        if (this.chatInteractor.isRequestBeingProcessed()) {
            return false;
        }
        String currentContentId = this.chatInteractor.getCurrentMessageContentId();
        return this.lastValidationContentId != null && this.lastValidationContentId.equals(currentContentId);
    }

    private boolean canProceedWithCorrection() {
        if (this.chatInteractor.isRequestBeingProcessed()) {
            return false;
        }
        String currentContentId = this.chatInteractor.getCurrentMessageContentId();
        return this.validationMessageId != null && this.validationMessageId.equals(currentContentId);
    }

    private void handleValidationProblems(String content, int startOffset, int endOffset, String validationResult, boolean isEntireDocument, String documentUrl, boolean isForAppliendContent) throws InterruptedException {
        boolean canValidateAgain;
        boolean canShowValidationReport = this.canShowValidationReport();
        if (!canShowValidationReport) {
            logger.debug("Cannot show validation report - user has continued the conversation");
            return;
        }
        this.validationMessageId = this.chatInteractor.showValidationErrors(validationResult);
        boolean bl = canValidateAgain = this.chatInteractor.countTrailingValidationMessages() < 3;
        if (!canValidateAgain) {
            logger.debug("Automatic correction not allowed - the AI has failed to validate 3 times");
            this.chatInteractor.notifyValidationCorrectionAborted(Translator.getInstance().getTranslation("Validation_max_failed_fixes_aborted"));
            return;
        }
        this.chatInteractor.notifyValidationCorrectionInProgress();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("problemDescriptions", validationResult);
            Flow.Publisher aiCompletionPublisher = InvokeActionHelperProvider.getInvokeActionHelper().invokeActionIncremental("pseudoaction.autovalidate.fix", null, content, params);
            if (this.canProceedWithCorrection()) {
                StringBuilder completion = new StringBuilder();
                ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
                this.chatInteractor.startCorrectionMessage(() -> this.cancelCurrentValidationTask());
                Flowable flowable = ReactiveUtil.translateFlowToFlowable(aiCompletionPublisher);
                flowable.blockingSubscribe(item -> {
                    if (item != null && !item.isEmpty()) {
                        completion.append((String)item);
                        this.chatInteractor.showCorrectionMessageChunk((String)item);
                    }
                }, throwable -> {
                    if (throwable instanceof InterruptedException) {
                        logger.debug("Validation correction was interrupted", throwable);
                        Thread.currentThread().interrupt();
                    }
                    exceptions.add((Throwable)throwable);
                });
                if (isEntireDocument) {
                    this.chatInteractor.finishCorrectingDocument(completion.toString(), exceptions, documentUrl, isForAppliendContent);
                } else {
                    this.chatInteractor.finishCorrectingContentRange(completion.toString(), exceptions, startOffset, endOffset, isForAppliendContent);
                }
                this.chatInteractor.notifyValidationCorrectionCompleted(exceptions.isEmpty());
            } else {
                logger.debug("Skipping correction application - user has continued the conversation");
                this.chatInteractor.notifyValidationCorrectionAborted(Translator.getInstance().getTranslation("Validation_fixes_aborted"));
            }
        }
        catch (IOException e) {
            logger.debug("Error during validation correction", (Throwable)e);
            this.chatInteractor.notifyValidationCorrectionCompleted(false);
        }
    }

    String getDocumentContent(URL url) throws IOException {
        return FunctionsAndRAGHelperProvider.getProjectRAGHelper().getDocumentContent(url.toExternalForm());
    }

    public void shutdown() {
        this.cancelCurrentValidationTask();
        this.scheduledExecutorService.shutdownNow();
    }

    @Override
    public void aiResponseReceived(String url, String response) {
        if (AutoValidationManager.isAutoValidationWholeDocEnabled() && XMLDocumentResponseTypeDetector.isLikelyCompleteDocument(response, TextUtils.getContentType(url))) {
            this.aiCompleteDocumentReceived(url, response);
        } else if (AutoValidationManager.isAutoValidationXMLFragmentsEnabled() && XMLDocumentResponseTypeDetector.containsXMLFragment(response, TextUtils.getContentType(url))) {
            this.aiXMLFragmentReceived(url, response);
        }
    }

    @Override
    public void aiCompleteDocumentReceived(String url, String response) {
        if (AutoValidationManager.isAutoValidationWholeDocEnabled() && response != null) {
            this.lastValidationContentId = this.chatInteractor.getCurrentMessageContentId();
            String content = TextUtils.extractInsertionContentFromResponseForURL(response, url);
            this.submitDebouncedValidationTask(() -> this.validateEntireContent(URLUtil.convertToURL((String)url), content, false));
        }
    }

    private void aiXMLFragmentReceived(String url, String response) {
        if (AutoValidationManager.isAutoValidationXMLFragmentsEnabled()) {
            this.lastValidationContentId = this.chatInteractor.getCurrentMessageContentId();
            String content = TextUtils.extractInsertionContentFromResponseForURL(response, url);
            this.submitDebouncedValidationTask(() -> this.validateXMLFragmentResponse(URLUtil.convertToURL((String)url), content));
        }
    }

    private void validateXMLFragmentResponse(URL url, String response) {
        ValidateContentHelper validateHelper = ValidateContentHelperProvider.getValidateContentHelper();
        if (validateHelper != null) {
            try {
                String validationResult;
                if (response != null && (validationResult = validateHelper.validateXMLWithSAX(response)) != null && !validationResult.isEmpty() && !validationResult.equals("[]")) {
                    this.handleValidationProblems(response, 0, response.length(), validationResult, false, url.toString(), false);
                }
            }
            catch (InterruptedException e) {
                logger.debug("Validation task was cancelled", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

