/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.types;

import com.oxygenxml.positron.core.actions.types.ReplaceCapableActionInteractor;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.util.Objects;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceFragmentActionInteractor
extends ReplaceCapableActionInteractor
implements Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ReplaceFragmentActionInteractor.class.getName());

    public ReplaceFragmentActionInteractor(AIActionDetails details) {
        super(details);
    }

    @Override
    public String getActionChangeDescription() {
        return TRANSLATOR.getTranslation("Replace_action_tooltip");
    }

    @Override
    public String getPreviewChangeDescription() {
        return TRANSLATOR.getTranslation("Preview_replace_tooltip");
    }

    @Override
    public void previewDocumentModifications(String response) {
        if (this.completionInserter == null) {
            LOGGER.warn("Cannot preview document modifications: completionInserter is null. Action may have been interrupted by editor switch.");
            return;
        }
        int[] startAndEndOffsets = this.getUpdatedStartAndEndOffsets();
        boolean reloadedAfterPreview = this.completionInserter.previewReplaceSelectionWithSuggestion(Objects.requireNonNullElse(response = TextUtils.extractInsertionContentFromResponseForInserter(response, this.completionInserter), this.initialSuggestion), true, startAndEndOffsets[0], startAndEndOffsets[1]);
        if (reloadedAfterPreview) {
            try {
                this.beforeStartOffset = null;
                this.afterEndOffset = null;
                this.startOffset = this.completionInserter.createPosition(0);
                this.endOffset = this.completionInserter.createPosition(this.completionInserter.getRootEnd());
            }
            catch (BadLocationException ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public int[] modifyDocument(String response) {
        if (this.completionInserter == null) {
            LOGGER.warn("Cannot modify document: completionInserter is null. Action may have been interrupted by editor switch.");
            return null;
        }
        response = TextUtils.extractInsertionContentFromResponseForInserter(response, this.completionInserter);
        int[] startAndEndOffsets = this.getUpdatedStartAndEndOffsets();
        int[] insertedOffsets = this.completionInserter.replaceSelectionWithSuggestion(Objects.requireNonNullElse(response, this.initialSuggestion), true, startAndEndOffsets[0], startAndEndOffsets[1], false);
        this.initialSuggestion = Objects.requireNonNullElse(response, this.initialSuggestion);
        return insertedOffsets;
    }
}

