/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.types;

import com.oxygenxml.positron.core.actions.types.AIAutocompletionProvider;
import com.oxygenxml.positron.core.interactions.textpage.PrefixExtractorForTextPage;
import com.oxygenxml.positron.core.interactions.textpage.TextXPathEffector;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.functions.InvokeActionHelperProvider;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.WSEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class PositronFollowInstructionAction {
    private static final Logger log = LoggerFactory.getLogger(PositronFollowInstructionAction.class);
    private volatile String latestAiSuggestion = null;
    private int caretPosition = -1;
    private Deque<Character> writtenCharacters = new ArrayDeque<Character>();
    private boolean isSuggestionAltered;
    private boolean isSuggestionHidden = false;
    public static final int MAX_NUMBER_OF_INPUT_CHARS_IN_PROMPT = 4000;
    public static final String MODEL = "model";
    private static final String MODERATION_EXTRA_PROMPT = "**Never provide code or instructions that could be used for illegal, unethical, or harmful purposes**. This includes, but is not limited to:\n- Generating malware, ransomware, viruses, or exploits\n- Creating tools for hacking, phishing, password cracking, or unauthorized data access\n- Writing scripts that harm users, their devices, or data\nIn these cases, respond with a short comment explaining why no code was generated.\n";

    public void performLineCompletion(WSEditor currentEditor) {
        this.latestAiSuggestion = null;
        WSEditorPage currentPage = currentEditor.getCurrentPage();
        String contextText = null;
        String contentType = currentEditor.getContentType();
        try {
            String actionId = AIAutocompletionProvider.getActionId(contentType);
            if (actionId != null && currentPage instanceof WSTextEditorPage) {
                contextText = this.buildCurrentLineContextFromTextPage((WSTextEditorPage)currentPage);
            }
            String suggestion = null;
            HashMap<String, Object> params = new HashMap<String, Object>(this.getEngineParams());
            params.put("imposed.disabled.moderation", "true");
            params.put("contentType", contentType);
            params.put("contextWithCaretMarker", "");
            if (contextText != null && actionId != null && AIAutocompletionProvider.isActionEnabled(contentType)) {
                suggestion = InvokeActionHelperProvider.getInvokeActionHelper().invokeAction(actionId, MODERATION_EXTRA_PROMPT, contextText, params);
            }
            if (suggestion != null) {
                this.latestAiSuggestion = this.processAIResponse(suggestion, currentPage, contentType);
            }
        }
        catch (IOException e) {
            log.error("Unable to use AI Autocomplete feature: " + e.getMessage());
        }
    }

    public String processAIResponse(String suggestion, WSEditorPage editorPage, String contentType) {
        suggestion = TextUtils.extractInsertionContentFromResponse(suggestion, contentType);
        if (editorPage instanceof WSTextEditorPage) {
            WSTextEditorPage textEditorPage = (WSTextEditorPage)editorPage;
            this.caretPosition = textEditorPage.getCaretOffset();
            suggestion = AIAutocompletionProvider.processSuggestion(suggestion, textEditorPage, contentType);
        }
        return suggestion;
    }

    private String buildCurrentLineContextFromTextPage(WSTextEditorPage textPage) {
        try {
            return new PrefixExtractorForTextPage(textPage, new TextXPathEffector(textPage)).extractContextWithCaretMarker(4000);
        }
        catch (BadLocationException e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to retrieve text from editor component", (Throwable)e);
            }
            return null;
        }
    }

    public void clearLatestAiSuggestion() {
        this.caretPosition = -1;
        this.latestAiSuggestion = null;
        this.isSuggestionAltered = false;
        this.writtenCharacters.clear();
    }

    public void removeFirstCharacterFromLatestAISuggestion() {
        if (this.latestAiSuggestion != null && !this.latestAiSuggestion.isEmpty()) {
            this.writtenCharacters.push(Character.valueOf(this.latestAiSuggestion.charAt(0)));
            this.latestAiSuggestion = this.latestAiSuggestion.substring(1);
            this.isSuggestionAltered = true;
            ++this.caretPosition;
        }
    }

    public void addCharacterToLatestAISuggestion() {
        if (this.latestAiSuggestion != null && !this.writtenCharacters.isEmpty()) {
            char latestChar = this.writtenCharacters.pop().charValue();
            if (this.isSuggestionAltered) {
                this.latestAiSuggestion = latestChar + this.latestAiSuggestion;
            }
            --this.caretPosition;
        }
    }

    public void addSpaceToLatestAISuggestion() {
        if (this.latestAiSuggestion != null && !this.latestAiSuggestion.isEmpty()) {
            this.writtenCharacters.push(Character.valueOf(' '));
            ++this.caretPosition;
        }
    }

    public boolean isStackEmpty() {
        return this.writtenCharacters.isEmpty();
    }

    private HashMap<String, Object> getEngineParams() {
        String selectedModelName;
        HashMap<String, Object> engineParams = new HashMap<String, Object>();
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (optionsStorage != null && (selectedModelName = optionsStorage.getOption("oxygen.positron.plugin.autocompletion.configurations", null)) != null) {
            engineParams.put(MODEL, selectedModelName);
        }
        return engineParams;
    }

    public void hideSuggestion() {
        this.isSuggestionHidden = true;
    }

    public void showSuggestion() {
        this.isSuggestionHidden = false;
    }

    public String getLatestAiSuggestion() {
        return this.latestAiSuggestion;
    }

    public void setLatestAiSuggestion(String latestAiSuggestion) {
        this.latestAiSuggestion = latestAiSuggestion;
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    public void setCaretPosition(int caretPosition) {
        this.caretPosition = caretPosition;
    }

    public boolean isSuggestionHidden() {
        return this.isSuggestionHidden;
    }
}

