/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.types;

import com.oxygenxml.positron.core.AICompletionProviderResolver;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.actions.MessagePresenter;
import com.oxygenxml.positron.core.actions.OperationCancelledByUserException;
import com.oxygenxml.positron.core.actions.OperationSemaphoreHandler;
import com.oxygenxml.positron.core.actions.types.BaseActionInteractor;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.interactions.ContextInfo;
import com.oxygenxml.positron.core.progress.OperationProgressPresenter;
import com.oxygenxml.positron.utilities.json.AdditionalInfo;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositronAIPromptUserAction
extends PositronAIActionBase {
    private static final Logger log = LoggerFactory.getLogger(PositronAIPromptUserAction.class);

    public PositronAIPromptUserAction(BaseActionInteractor actionInteractor, AICompletionProviderResolver completionProviderResolver, MessagePresenter messagePresenter, ChatInteractor chatInteractor, OperationSemaphoreHandler operationSemaphoreHandler, OperationProgressPresenter statusPanel) {
        super(actionInteractor, completionProviderResolver, messagePresenter, chatInteractor, operationSemaphoreHandler, statusPanel);
    }

    @Override
    protected ContextInfo getTextToProcess() throws CannotComputeCompletionDetailsException, OperationCancelledByUserException, BadLocationException {
        String textToProcess = this.getContentFromUserDialog();
        if (textToProcess == null || textToProcess.isEmpty()) {
            throw new OperationCancelledByUserException(this.getActionCanceledMessage());
        }
        int caretOffset = this.prefixExtractor != null ? this.prefixExtractor.getCaretOffset() : 0;
        return new ContextInfo(textToProcess, caretOffset, caretOffset);
    }

    private String getContentFromUserDialog() {
        String toReturn = "";
        if (this.userInputProvider != null) {
            toReturn = this.userInputProvider.askUserForInput(this.details.getShortDescription(), this.getDialogDescription(), "", TRANSLATOR.getTranslation("Run"), this.getInitialContent(), true);
        } else {
            log.warn("The user input aquirer is not initialized.");
        }
        return toReturn;
    }

    private String getInitialContent() {
        Map properties;
        String initialContent = "";
        AdditionalInfo additionalInfo = this.details.getAdditionalInfo();
        if (additionalInfo != null && (properties = additionalInfo.getProperties()) != null) {
            initialContent = properties.getOrDefault("prompt-example", "");
        }
        return initialContent;
    }

    protected String getDialogDescription() {
        return this.details.getDescription();
    }
}

