/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.types;

import com.oxygenxml.positron.core.AICompletionProviderResolver;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.actions.MessagePresenter;
import com.oxygenxml.positron.core.actions.OperationCancelledByUserException;
import com.oxygenxml.positron.core.actions.OperationSemaphoreHandler;
import com.oxygenxml.positron.core.actions.types.AIFixActionInteractor;
import com.oxygenxml.positron.core.actions.types.BaseActionInteractor;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.interactions.ContextInfo;
import com.oxygenxml.positron.core.interactions.textpage.NodeDetectorForTextPage;
import com.oxygenxml.positron.core.interactions.textpage.NodeOffset;
import com.oxygenxml.positron.core.progress.OperationProgressPresenter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.WSEditorPage;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.xml.WSXMLTextEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.xml.XPathException;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;

public class PositronAIFixAction
extends PositronAIActionBase {
    private static final Logger log = LoggerFactory.getLogger(PositronAIFixAction.class);
    private DocumentPositionedInfo currentDPI = null;
    public static final String PROBLEM_DESCRIPTION_PARAM_NAME = "problemDescription";

    public PositronAIFixAction(BaseActionInteractor actionInteractor, AICompletionProviderResolver completionProviderResolver, MessagePresenter messagePresenter, ChatInteractor chatInteractor, OperationSemaphoreHandler operationSemaphoreHandler, OperationProgressPresenter statusPanel) {
        super(actionInteractor, completionProviderResolver, messagePresenter, chatInteractor, operationSemaphoreHandler, statusPanel);
    }

    @Override
    protected ContextInfo getTextToProcess() throws CannotComputeCompletionDetailsException, OperationCancelledByUserException, BadLocationException, OperationCancelledByAiIgnoreException {
        StandalonePluginWorkspace pluginWS = (StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        ContextInfo imposedContext = null;
        if (this.currentDPI != null) {
            try {
                WSEditorPage currentPage;
                WSEditor editorAccess = pluginWS.getEditorAccess(new URL(this.currentDPI.getSystemID()), 0);
                WSEditorPage wSEditorPage = currentPage = editorAccess != null ? editorAccess.getCurrentPage() : null;
                if (currentPage instanceof WSAuthorEditorPage) {
                    WSAuthorEditorPage authorPage = (WSAuthorEditorPage)currentPage;
                    int[] startEndOffsets = authorPage.getStartEndOffsets(this.currentDPI);
                    AuthorDocumentFragment createDocumentFragment = authorPage.getDocumentController().createDocumentFragment(startEndOffsets[0], startEndOffsets[1] - 1);
                    String offendingString = authorPage.getDocumentController().serializeFragmentToXML(createDocumentFragment);
                    imposedContext = new ContextInfo("Correct this content: " + offendingString, startEndOffsets[0], startEndOffsets[1]);
                } else if (currentPage instanceof WSTextEditorPage) {
                    WSTextEditorPage textPage = (WSTextEditorPage)currentPage;
                    int[] startEndOffsets = textPage.getStartEndOffsets(this.currentDPI);
                    String offendingString = textPage.getDocument().getText(startEndOffsets[0], startEndOffsets[1] - startEndOffsets[0]);
                    imposedContext = new ContextInfo("Correct this content: " + offendingString, startEndOffsets[0], startEndOffsets[1]);
                }
            }
            catch (Exception ex) {
                throw new CannotComputeCompletionDetailsException(ex.getMessage());
            }
        }
        return imposedContext != null ? imposedContext : super.getTextToProcess();
    }

    public void performFix(DocumentPositionedInfo currentDPI) {
        this.currentDPI = currentDPI;
        ContextInfo initialContextFromDPI = null;
        try {
            WSEditorPage currentPage;
            StandalonePluginWorkspace pluginWS = (StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
            WSEditor editorAccess = pluginWS.getEditorAccess(new URL(currentDPI.getSystemID()), 0);
            WSEditorPage wSEditorPage = currentPage = editorAccess != null ? editorAccess.getCurrentPage() : null;
            if (currentPage instanceof WSAuthorEditorPage) {
                initialContextFromDPI = this.buildInitialContextFromAuthorPage(currentDPI, currentPage);
            } else if (currentPage instanceof WSXMLTextEditorPage) {
                initialContextFromDPI = this.buildInitialContextFromTextPage(currentDPI, currentPage);
            }
        }
        catch (MalformedURLException | BadLocationException | XPathException e) {
            log.error((Object)e, e);
        }
        if (this.actionInteractor instanceof AIFixActionInteractor) {
            ((AIFixActionInteractor)this.actionInteractor).setSpecificParameters(Map.of(PROBLEM_DESCRIPTION_PARAM_NAME, currentDPI.getMessage()));
            ((AIFixActionInteractor)this.actionInteractor).setPreviouslyUsedContext(null);
            ((AIFixActionInteractor)this.actionInteractor).setOriginalContext(initialContextFromDPI);
        }
        this.actionPerformed(null);
    }

    private ContextInfo buildInitialContextFromTextPage(DocumentPositionedInfo currentDPI, WSEditorPage currentPage) throws BadLocationException, XPathException {
        WSXMLTextEditorPage wsTextBasedEditorPage = (WSXMLTextEditorPage)currentPage;
        int[] startEndOffsets = wsTextBasedEditorPage.getStartEndOffsets(currentDPI);
        NodeDetectorForTextPage nodeDetectorForTextPage = new NodeDetectorForTextPage((WSTextEditorPage)wsTextBasedEditorPage, startEndOffsets[0], startEndOffsets[1]);
        NodeOffset closestOffset = nodeDetectorForTextPage.findFirstNodeThatFullyContainsTargetOffsets();
        if (closestOffset != null) {
            int start = closestOffset.getStart();
            int end = closestOffset.getEnd();
            String text = wsTextBasedEditorPage.getDocument().getText(start, end - start);
            return new ContextInfo(text, start, end);
        }
        return null;
    }

    private ContextInfo buildInitialContextFromAuthorPage(DocumentPositionedInfo currentDPI, WSEditorPage currentPage) throws BadLocationException {
        WSAuthorEditorPage wsAuthorEditorPage = (WSAuthorEditorPage)currentPage;
        int[] startEndOffsets = wsAuthorEditorPage.getStartEndOffsets(currentDPI);
        AuthorDocumentController controller = wsAuthorEditorPage.getDocumentController();
        List nodesToSelect = controller.getNodesToSelect(startEndOffsets[0], startEndOffsets[1]);
        if (!nodesToSelect.isEmpty()) {
            AuthorNode node = (AuthorNode)nodesToSelect.get(0);
            String text = controller.serializeFragmentToXML(controller.createDocumentFragment(node.getStartOffset(), node.getEndOffset(), true));
            return new ContextInfo(text, node.getStartOffset(), node.getEndOffset() + 1);
        }
        return null;
    }
}

