/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.types;

import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.core.AICompletionDetailsProvider;
import com.oxygenxml.positron.core.AICompletionProviderResolver;
import com.oxygenxml.positron.core.AICompletionStreamResponse;
import com.oxygenxml.positron.core.ActionInterruptedByEditorDeselectionException;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.actions.MessagePresenter;
import com.oxygenxml.positron.core.actions.OperationCancelledByUserException;
import com.oxygenxml.positron.core.actions.OperationSemaphoreHandler;
import com.oxygenxml.positron.core.actions.ParamsExpander;
import com.oxygenxml.positron.core.actions.PositronActionConfigurationResult;
import com.oxygenxml.positron.core.actions.types.ActionSpecificParamsExpandingException;
import com.oxygenxml.positron.core.actions.types.BaseActionInteractor;
import com.oxygenxml.positron.core.actions.types.PositronAIActionCustomizer;
import com.oxygenxml.positron.core.actions.types.PreActionListener;
import com.oxygenxml.positron.core.actions.types.ReplaceCapableActionInteractor;
import com.oxygenxml.positron.core.actions.types.RequestMessagesCreationException;
import com.oxygenxml.positron.core.actions.types.UsableContentProcessingException;
import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.api.CompletionResponseUtil;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.chat.ProgressActionInteractor;
import com.oxygenxml.positron.core.interactions.ContentInserter;
import com.oxygenxml.positron.core.interactions.ContextInfo;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.interactions.IUserInputProvider;
import com.oxygenxml.positron.core.interactions.ReadOnlyController;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.progress.OperationProgressPresenter;
import com.oxygenxml.positron.core.progress.ProgressTracker;
import com.oxygenxml.positron.core.responses.handler.ResponseParser;
import com.oxygenxml.positron.core.service.PositronServiceUtil;
import com.oxygenxml.positron.core.tools.ChatToolsExecutorListener;
import com.oxygenxml.positron.core.tools.ToolsExecutionCapability;
import com.oxygenxml.positron.core.tools.ToolsSessionManager;
import com.oxygenxml.positron.core.util.ContextExtractorUtil;
import com.oxygenxml.positron.core.util.StandaloneAuthorDocumentModelCreatorImpl;
import com.oxygenxml.positron.core.util.StandaloneHrefInfoProvider;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.core.util.attach.ImageAttachmentsFilter;
import com.oxygenxml.positron.core.util.attach.ImageAttachmentsFilterImpl;
import com.oxygenxml.positron.utilities.exceptions.InvalidMessageException;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ActionParam;
import com.oxygenxml.positron.utilities.json.ActionType;
import com.oxygenxml.positron.utilities.json.Parameters;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.execution.StoppedByUserException;
import ro.sync.basic.util.concurrent.SemaphoreTimeoutException;

public class PositronAIActionBase
extends AbstractAction
implements Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PositronAIActionBase.class.getName());
    protected static final Translator TRANSLATOR = Translator.getInstance();
    private final ImageAttachmentsFilter extensionFilter = new ImageAttachmentsFilterImpl();
    protected BaseActionInteractor actionInteractor;
    protected AIActionDetails details;
    protected AICompletionProviderResolver completionProviderResolver;
    protected DocumentContentInteractor prefixExtractor;
    protected MessagePresenter messagePresenter;
    protected ContentInserter completionInserter;
    private final ProgressTracker progressTracker;
    protected OperationSemaphoreHandler operationSemaphoreHandler;
    protected String initialText = "";
    protected boolean isSelectionEndingWithSpace;
    protected List<Message> requestMessages;
    protected ChatInteractor chatInteractor;
    protected IUserInputProvider userInputProvider;
    protected PositronAIActionCustomizer actionCustomizer;
    protected OperationProgressPresenter statusPanel;
    private PreActionListener preActionListener;
    private boolean directlyPerformAction;
    private boolean editingBindingChanged;
    private boolean isShowSideView = true;
    private String imposedChatStartMessage;

    public PositronAIActionBase(BaseActionInteractor actionInteractor, AICompletionProviderResolver completionProviderResolver, MessagePresenter messagePresenter, ChatInteractor chatInteractor, OperationSemaphoreHandler operationSemaphoreHandler, OperationProgressPresenter statusPanel) {
        this.statusPanel = statusPanel;
        this.details = actionInteractor.getActionDetails();
        this.actionInteractor = actionInteractor;
        this.completionProviderResolver = completionProviderResolver;
        this.messagePresenter = messagePresenter;
        this.chatInteractor = chatInteractor;
        this.operationSemaphoreHandler = Objects.requireNonNull(operationSemaphoreHandler);
        this.putValue("Name", this.details.getTitle());
        this.reconfigureTooltip();
        this.progressTracker = new ProgressTracker(statusPanel){

            @Override
            public void cancelProgress(boolean byUser) {
                PositronAIActionBase.this.notifyActionCancelled();
                super.cancelProgress(byUser);
            }
        };
    }

    public void updateCompletionProviderResolver(AICompletionProviderResolver completionProviderResolver) {
        this.completionProviderResolver = completionProviderResolver;
    }

    public void reconfigureTooltip() {
        String params;
        String descr = Optional.ofNullable(this.details.getDescription()).orElse("");
        String tooltipText = descr + (params = ParamsExpander.getConfigurableParamsTooltip(this.details.getId(), this.details.getExpandParams()));
        this.putValue("ShortDescription", tooltipText.isBlank() ? null : tooltipText.trim());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.actionPerformed(false);
    }

    public void actionPerformed(boolean directlyPerformAction) {
        this.directlyPerformAction = directlyPerformAction;
        if (this.chatInteractor.isRequestBeingProcessed()) {
            this.messagePresenter.showStatusMessage(String.format("Unable to start action '%s' because another action is in progress in the chat panel.", this.details.getTitle()), true);
        } else {
            try {
                ToolsSessionManager toolsSessionManager = ToolsSessionManager.getInstance();
                if (toolsSessionManager.isToolsDocumentsChangesSupportAvailable() && toolsSessionManager.getToolsDocumentsChangesManager().hasChangesWhichCanBeApproved()) {
                    toolsSessionManager.getToolsDocumentsChangesManager().showChangesForApproval();
                    if (toolsSessionManager.getToolsDocumentsChangesManager().hasChangesWhichCanBeApproved()) {
                        return;
                    }
                }
                if (this.preActionListener != null) {
                    this.preActionListener.actionAboutToBeExecuted(this);
                }
                this.operationSemaphoreHandler.getOperationInProgressSemaphore().aquireWithTimeout(100);
                String currentStatus = this.getActionInProgressMessage();
                this.messagePresenter.showStatusMessage(currentStatus);
                PositronAIActionBase.prepareSelection(this.prefixExtractor, this.details);
                this.performAction(currentStatus);
            }
            catch (BadLocationException ex) {
                LOGGER.error((Object)ex, (Throwable)ex);
                this.messagePresenter.showStatusMessage("Could not collect the text to process. " + ex.getMessage(), true);
            }
            catch (SemaphoreTimeoutException ex) {
                LOGGER.error((Object)ex, (Throwable)ex);
                this.messagePresenter.showStatusMessage(String.format("Unable to start action '%s' because another action is in progress.", this.details.getTitle()), true);
            }
            catch (Throwable t) {
                LOGGER.error((Object)t, t);
                this.handleContentGatheringException(t);
            }
        }
    }

    static void prepareSelection(DocumentContentInteractor prefixExtractor, AIActionDetails details) {
        if (prefixExtractor != null && details != null) {
            prefixExtractor.prepareSelectionForReplaceAction(details.getInputContext());
        }
    }

    private void performAction(String currentStatus) throws BadLocationException {
        try {
            this.setPageReadOnly(currentStatus);
            ContextInfo contextInfo = this.getTextToProcess();
            this.runActionInContextNotBlockedByAiIgnore(contextInfo);
        }
        catch (OperationCancelledByAiIgnoreException e) {
            this.startActionInContextBlockedByAiIgnore();
        }
        catch (OperationCancelledByUserException e) {
            this.setPageEditable();
            this.notifyActionCancelled();
            this.notifyChatAboutCancelAction(e.getMessage());
            this.releaseSemaphore();
            this.initialText = "";
            this.imposedChatStartMessage = "";
        }
        catch (UsableContentProcessingException e) {
            this.treatUsableContentProcessingException(e);
        }
        catch (CannotComputeCompletionDetailsException | ActionSpecificParamsExpandingException | RequestMessagesCreationException e) {
            LOGGER.debug((Object)e, (Throwable)e);
            this.handleContentGatheringException(e);
        }
        catch (Throwable t) {
            LOGGER.error((Object)t, t);
            this.handleContentGatheringException(t);
        }
    }

    private void startActionInContextBlockedByAiIgnore() {
        final ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        RunnableAndChatToolsExecutorListener toRunInBackground = new RunnableAndChatToolsExecutorListener();
        toRunInBackground.runnable = new Runnable(){

            @Override
            public void run() {
                List<Message> msgs = Arrays.asList(new Message(RoleType.USER, (MessageContent)new MessageTextContent(PositronAIActionBase.this.details.getTitle())));
                try {
                    PositronAIActionBase.this.chatInteractor.startChatForAction(PositronAIActionBase.this.details, PositronAIActionBase.this.actionInteractor.getExpandedActionParams(), msgs, PositronAIActionBase.this.imposedChatStartMessage, PositronAIActionBase.this.isShowSideView);
                    PositronAIActionBase.this.chatInteractor.setInitialActionMessages(msgs);
                }
                catch (OperationCancelledByAiIgnoreException operationCancelledByAiIgnoreException) {
                    // empty catch block
                }
                exceptions.add(new OperationCancelledByAiIgnoreException());
            }
        };
        toRunInBackground.chatToolsExecutorListener = new ChatToolsExecutorListener(this.chatInteractor, this.actionInteractor);
        Runnable toDoWhenTaskDone = this.createDoWhenTaskDoneRunnable(0, 0, new StringBuilder(), new StringBuilder(), exceptions);
        this.startActionNow(toRunInBackground, toDoWhenTaskDone);
    }

    private void runActionInContextNotBlockedByAiIgnore(ContextInfo contextInfo) throws UsableContentProcessingException, RequestMessagesCreationException, ActionSpecificParamsExpandingException, OperationCancelledByUserException {
        PositronActionConfigurationResult result;
        String usableContent = contextInfo.getUsableContent();
        if (this.details.getAdditionalInfo() != null && "line_numbers".equals(this.details.getAdditionalInfo().getProperties().get("input_flavor"))) {
            usableContent = TextUtils.addLineNumbering(usableContent);
        }
        this.isSelectionEndingWithSpace = usableContent.endsWith(" ");
        this.initialText = usableContent.trim();
        this.processUsableContent(this.initialText);
        if (this.actionInteractor instanceof ReplaceCapableActionInteractor) {
            ((ReplaceCapableActionInteractor)this.actionInteractor).setUserInput(this.initialText);
        }
        this.requestMessages = this.createRequestMessage();
        Map<String, String> actionSpecificParms = this.getExpandedActionSpecificParms(this.details.getExpandParams());
        if (this.actionCustomizer != null && (result = this.actionCustomizer.customizeAction(this)) == PositronActionConfigurationResult.CANCELLED) {
            throw new OperationCancelledByUserException(this.getActionCanceledMessage());
        }
        this.reconfigureTooltip();
        this.performActionOnThread(this.requestMessages, contextInfo.getStartOffset(), contextInfo.getEndOffset(), actionSpecificParms);
    }

    protected void treatUsableContentProcessingException(UsableContentProcessingException e) {
        LOGGER.debug((Object)e, (Throwable)e);
        this.handleContentGatheringException(e);
    }

    protected void processUsableContent(String content) throws UsableContentProcessingException {
    }

    protected List<Message> createRequestMessage() throws RequestMessagesCreationException {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(new Message(RoleType.USER, (MessageContent)new MessageTextContent(this.initialText)));
        return messages;
    }

    protected Map<String, String> getExpandedActionSpecificParms(List<ActionParam> params) throws ActionSpecificParamsExpandingException {
        return Collections.emptyMap();
    }

    private void handleContentGatheringException(Throwable t) {
        this.handleActionStoppedPrematurely();
        this.messagePresenter.showStatusMessage(t.getMessage(), true);
        this.messagePresenter.showStatusMessage(this.getActionCanceledMessage());
        this.chatInteractor.showMessageForNotSuccessfulAction(t.getMessage(), false, false, true, null);
    }

    protected void handleActionStoppedPrematurely() {
        this.setPageEditable();
        this.releaseSemaphore();
        this.chatInteractor.notifyActionStopped();
        this.initialText = "";
        this.imposedChatStartMessage = "";
    }

    private void performActionOnThread(List<Message> requestMessages, int startOffset, int endOffset, Map<String, String> actionSpecificParms) {
        StringBuilder aiCompletionBuilder = new StringBuilder();
        StringBuilder responseAIModelBuilder = new StringBuilder();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        RunnableAndChatToolsExecutorListener toRunInBackground = this.createDoInBackgroundRunnable(requestMessages, aiCompletionBuilder, responseAIModelBuilder, exceptions, actionSpecificParms);
        Runnable toDoWhenTaskDone = this.createDoWhenTaskDoneRunnable(startOffset, endOffset, aiCompletionBuilder, responseAIModelBuilder, exceptions);
        this.startActionNow(toRunInBackground, toDoWhenTaskDone);
    }

    private void startActionNow(final RunnableAndChatToolsExecutorListener toRunInBackground, Runnable toDoWhenTaskDone) {
        this.chatInteractor.setCurrentActionProgressInteractor(new ProgressActionInteractor(){

            @Override
            public void stopProgressAction() {
                toRunInBackground.chatToolsExecutorListener.stop();
                PositronAIActionBase.this.progressTracker.cancelProgress(true);
            }
        });
        this.editingBindingChanged = false;
        this.progressTracker.startTracking(toRunInBackground.runnable, toDoWhenTaskDone);
    }

    private Runnable createDoWhenTaskDoneRunnable(final int startOffset, final int endOffset, final StringBuilder aiCompletionBuilder, final StringBuilder responseAIModelBuilder, final List<Throwable> exceptions) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block9: {
                    PositronAIActionBase.this.setPageEditable();
                    if (PositronAIActionBase.this.progressTracker.isCancelledByUser() != null && PositronAIActionBase.this.progressTracker.isCancelledByUser().booleanValue()) {
                        exceptions.add(new StoppedByUserException());
                    }
                    try {
                        BaseActionInteractor effectiveActionInteractor = PositronAIActionBase.this.actionInteractor;
                        if (PositronAIActionBase.this.editingBindingChanged) {
                            PositronAIActionBase.this.editingBindingChanged = false;
                            effectiveActionInteractor = null;
                        }
                        AICompletionDetailsProvider provider = PositronAIActionBase.this.getCompletionProviderForAction();
                        String aiCompletion = PositronServiceUtil.handleStreamResult(aiCompletionBuilder.toString(), responseAIModelBuilder.toString(), exceptions, provider, effectiveActionInteractor, PositronAIActionBase.this.chatInteractor, PositronAIActionBase.this.messagePresenter);
                        if (aiCompletion.isEmpty()) break block9;
                        if (PositronAIActionBase.this.details.getComputedType() != ActionType.SHOW_RESPONSE) {
                            try {
                                PositronAIActionBase.this.handleSuggestionInternal(aiCompletion, startOffset, endOffset);
                            }
                            catch (BadLocationException e) {
                                LOGGER.error((Object)e, (Throwable)e);
                            }
                        }
                        if (!PositronAIActionBase.this.progressTracker.isCanceled()) {
                            PositronAIActionBase.this.messagePresenter.showStatusMessage(PositronAIActionBase.this.getActionCompletedMessage());
                        }
                    }
                    finally {
                        PositronAIActionBase.this.chatInteractor.notifyActionStopped();
                        PositronAIActionBase.this.initialText = "";
                        PositronAIActionBase.this.imposedChatStartMessage = "";
                        PositronAIActionBase.this.releaseSemaphore();
                    }
                }
            }
        };
    }

    protected boolean shouldCallReferencedFunctions() {
        return true;
    }

    protected final AICompletionDetailsProvider getCompletionProviderForAction() {
        return this.completionProviderResolver.getCompletionProviderForModel(this.details, null);
    }

    private RunnableAndChatToolsExecutorListener createDoInBackgroundRunnable(final List<Message> requestMessages, final StringBuilder aiCompletionBuilder, final StringBuilder responseAIModelBuilder, final List<Throwable> exceptions, final Map<String, String> actionSpecificParms) {
        final ChatToolsExecutorListener chatToolsExecutorListener = new ChatToolsExecutorListener(this.chatInteractor, this.actionInteractor);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block15: {
                    AICompletionDetailsProvider provider = PositronAIActionBase.this.getCompletionProviderForAction();
                    try {
                        AICompletionStreamResponse aiCompletionResponse;
                        Parameters parameters;
                        Map<String, String> expandedActionParams = PositronAIActionBase.this.actionInteractor.getExpandedActionParams();
                        if (actionSpecificParms != null && !actionSpecificParms.isEmpty()) {
                            expandedActionParams.putAll(actionSpecificParms);
                        }
                        PositronAIActionBase.this.actionInteractor.setDirectlyPerformAction(PositronAIActionBase.this.directlyPerformAction);
                        PositronAIActionBase.this.chatInteractor.startChatForAction(PositronAIActionBase.this.details, expandedActionParams, requestMessages, PositronAIActionBase.this.imposedChatStartMessage, PositronAIActionBase.this.isShowSideView);
                        PositronAIActionBase.this.chatInteractor.setInitialActionMessages(requestMessages);
                        if (PositronAIActionBase.this.imposedChatStartMessage != null && !PositronAIActionBase.this.imposedChatStartMessage.isEmpty()) {
                            Message imposedUserMessage = new Message(RoleType.USER, (MessageContent)new MessageTextContent(PositronAIActionBase.this.imposedChatStartMessage));
                            PositronAIActionBase.this.chatInteractor.storeMessage(imposedUserMessage);
                        }
                        if (provider instanceof ToolsExecutionCapability) {
                            provider.setToolsExecutorListener(chatToolsExecutorListener);
                            provider.setToolsConfirmationInteractor(chatToolsExecutorListener);
                        }
                        AIActionDetails action = PositronAIActionBase.this.details;
                        boolean shouldCallReferencedFunctions = PositronAIActionBase.this.shouldCallReferencedFunctions();
                        if (!shouldCallReferencedFunctions && (parameters = (action = PositronAIActionBase.this.details.clone()).getParameters()) != null) {
                            parameters.setFunctionRefs(null);
                        }
                        if ((aiCompletionResponse = provider.executeActionIncremental(action, requestMessages, expandedActionParams)) == null || aiCompletionResponse.getResponseContent() == null) break block15;
                        ResponseParser responseParser = new ResponseParser(aiCompletionResponse.isShouldBeStructuredResponse(), PositronAIActionBase.this.chatInteractor);
                        try {
                            aiCompletionResponse.getResponseContent().blockingSubscribe(chunk -> {
                                String content = CompletionResponseUtil.getCompletion((CompletionResponse)chunk);
                                String chunkModel = chunk.getModel();
                                if (chunkModel != null && responseAIModelBuilder.length() == 0) {
                                    responseAIModelBuilder.append(chunkModel);
                                    PositronAIActionBase.this.chatInteractor.showAIAssistantModel(chunkModel);
                                }
                                if (CompletionResponseUtil.hasToolCalls((CompletionResponse)chunk)) {
                                    aiCompletionBuilder.setLength(0);
                                }
                                if (content != null) {
                                    aiCompletionBuilder.append(content);
                                    responseParser.addNewChunk(content);
                                }
                            }, t -> {
                                if (t instanceof InterruptedException) {
                                    if (!PositronAIActionBase.this.progressTracker.isCancelledByUser().booleanValue()) {
                                        exceptions.add(new ActionInterruptedByEditorDeselectionException());
                                    }
                                    Thread.currentThread().interrupt();
                                } else {
                                    exceptions.add(t);
                                }
                            });
                        }
                        finally {
                            responseParser.completionEnd();
                        }
                    }
                    catch (OperationCancelledByAiIgnoreException e) {
                        exceptions.add(e);
                        PositronAIActionBase.this.progressTracker.cancelProgress(true);
                    }
                    catch (CannotComputeCompletionDetailsException | InvalidMessageException | CloneNotSupportedException | RuntimeException e) {
                        LOGGER.error((Object)e, e);
                        PositronAIActionBase.this.progressTracker.cancelProgress(false);
                        exceptions.add(e);
                    }
                    finally {
                        if (provider instanceof ToolsExecutionCapability) {
                            provider.removeToolsExecutorListener();
                            provider.removeToolsConfirmationInteractor();
                        }
                    }
                }
            }
        };
        RunnableAndChatToolsExecutorListener runnableAndListener = new RunnableAndChatToolsExecutorListener();
        runnableAndListener.runnable = runnable;
        runnableAndListener.chatToolsExecutorListener = chatToolsExecutorListener;
        return runnableAndListener;
    }

    private void notifyChatAboutCancelAction(String message) {
        this.chatInteractor.showMessageForNotSuccessfulAction(message, true, false, false, null);
        this.chatInteractor.notifyActionStopped();
    }

    public void handleSuggestionInternal(String suggestion, int startOffset, int endOffset) throws BadLocationException {
        this.actionInteractor.setAiInitialSuggestion(suggestion, startOffset, endOffset);
    }

    protected void setPageReadOnly(String currentStatus) {
        if (this.actionInteractor.isOperationThatChangesThePageContent()) {
            Optional.ofNullable(this.completionInserter).map(ContentInserter::getReadOnlyController).ifPresent(t -> t.setReadOnly(currentStatus));
        }
    }

    protected void setPageEditable() {
        if (this.actionInteractor.isOperationThatChangesThePageContent()) {
            Optional.ofNullable(this.completionInserter).map(ContentInserter::getReadOnlyController).ifPresent(ReadOnlyController::setEditable);
        }
    }

    private void notifyActionCancelled() {
        this.messagePresenter.showStatusMessage(this.getActionCanceledMessage());
    }

    protected void releaseSemaphore() {
        this.operationSemaphoreHandler.getOperationInProgressSemaphore().release();
    }

    protected ContextInfo getTextToProcess() throws CannotComputeCompletionDetailsException, OperationCancelledByUserException, BadLocationException, OperationCancelledByAiIgnoreException {
        return this.initialText == null || this.initialText.isEmpty() ? ContextExtractorUtil.computeContext(this.details, this.prefixExtractor, this.extensionFilter, new StandaloneAuthorDocumentModelCreatorImpl(), new StandaloneHrefInfoProvider()) : new ContextInfo(this.initialText, 0, 0);
    }

    public void setCompletionImplementation(ContentInserter completionInserter, DocumentContentInteractor docContentExtractor, IUserInputProvider userInputProvider) {
        if (this.progressTracker != null && this.progressTracker.isInProgress() && this.actionInteractor.isOperationThatChangesThePageContent()) {
            if (this.getActionInteractor().isDirectlyPerformAction()) {
                this.progressTracker.cancelProgress(false);
            } else {
                this.setPageEditable();
                this.editingBindingChanged = true;
            }
        }
        this.userInputProvider = userInputProvider;
        this.completionInserter = completionInserter;
        this.prefixExtractor = docContentExtractor;
        this.actionInteractor.setCompletionInserter(completionInserter);
    }

    public AIActionDetails getActionDetails() {
        return this.details;
    }

    public ProgressTracker getProgressTracker() {
        return this.progressTracker;
    }

    protected String getActionCanceledMessage() {
        return this.details.getShortDescription() + " - cancelled.";
    }

    protected String getActionInProgressMessage() {
        return this.details.getShortDescription() + " - in progress.";
    }

    private String getActionCompletedMessage() {
        return this.details.getShortDescription() + " - completed.";
    }

    public void setActionCustomizer(PositronAIActionCustomizer actionCustomizer) {
        this.actionCustomizer = actionCustomizer;
    }

    public PositronAIActionCustomizer getActionCustomizer() {
        return this.actionCustomizer;
    }

    @Override
    public PositronAIActionBase clone() throws CloneNotSupportedException {
        PositronAIActionBase clone = new PositronAIActionBase(this.actionInteractor.clone(), this.completionProviderResolver, this.messagePresenter, this.chatInteractor, this.operationSemaphoreHandler, this.statusPanel);
        clone.userInputProvider = this.userInputProvider;
        clone.completionInserter = this.completionInserter;
        clone.prefixExtractor = this.prefixExtractor;
        return clone;
    }

    public void setPreActionListener(PreActionListener preActionListener) {
        this.preActionListener = preActionListener;
    }

    public void setShowSideView(boolean isShowSideView) {
        this.isShowSideView = isShowSideView;
    }

    public void setInitialText(String initialText) {
        this.initialText = initialText;
    }

    public void setImposedChatStartMessage(String imposedStartMessage) {
        this.imposedChatStartMessage = imposedStartMessage;
    }

    public BaseActionInteractor getActionInteractor() {
        return this.actionInteractor;
    }

    private class RunnableAndChatToolsExecutorListener {
        private Runnable runnable;
        private ChatToolsExecutorListener chatToolsExecutorListener;

        private RunnableAndChatToolsExecutorListener() {
        }
    }
}

