/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.types;

import com.oxygenxml.positron.core.actions.types.ReplaceCapableActionInteractor;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.InsertMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.AuthorReviewController;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.WSEditorPage;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;

public class FollowInstructionInteractor
extends ReplaceCapableActionInteractor
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(FollowInstructionInteractor.class);
    private Map<String, String> parameters = Collections.emptyMap();

    public FollowInstructionInteractor(AIActionDetails details) {
        super(details);
    }

    @Override
    public Map<String, String> getExpandedActionParams() {
        Map<String, String> expandedParams = super.getExpandedActionParams();
        expandedParams.putAll(this.parameters);
        return expandedParams;
    }

    public void setSpecificParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public boolean canModifyDocument() {
        return true;
    }

    @Override
    public boolean canPreviewDocumentModifications() {
        return true;
    }

    @Override
    public void previewDocumentModifications(String response) {
        int[] offsets = this.getUpdatedStartAndEndOffsets();
        this.completionInserter.previewReplaceSelectionWithSuggestion(Objects.requireNonNullElse(response, this.initialSuggestion), true, offsets[0], offsets[1]);
    }

    @Override
    public int[] modifyDocument(String response) {
        int[] offsets = this.getUpdatedStartAndEndOffsets();
        this.initialSuggestion = null;
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        WSEditor currentEditorAccess = pluginWorkspace.getCurrentEditorAccess(0);
        WSEditorPage currentPage = currentEditorAccess.getCurrentPage();
        String originalReviewerName = null;
        boolean wasOriginalyNormalTracking = false;
        if (currentPage instanceof WSAuthorEditorPage) {
            WSAuthorEditorPage page = (WSAuthorEditorPage)currentPage;
            AuthorReviewController reviewController = page.getReviewController();
            originalReviewerName = reviewController.getReviewerAuthorName();
            if (!reviewController.isTrackingChanges()) {
                wasOriginalyNormalTracking = true;
                reviewController.toggleTrackChanges();
            }
            reviewController.setReviewerAuthorName(Translator.getInstance().getTranslation("AI_Assistant"));
        }
        InsertMode insertMode = new InsertMode(){

            public String getAction() {
                return "insert-after";
            }
        };
        List<InsertMode> insertModes = Arrays.asList(insertMode);
        int[] insertedOffsets = this.completionInserter.replaceSelectionWithSuggestion(response, true, offsets[0], offsets[1], true);
        if (currentPage instanceof WSAuthorEditorPage) {
            WSAuthorEditorPage page = (WSAuthorEditorPage)currentPage;
            AuthorReviewController reviewController = page.getReviewController();
            if (wasOriginalyNormalTracking) {
                reviewController.toggleTrackChanges();
            }
            reviewController.setReviewerAuthorName(originalReviewerName);
        }
        return insertedOffsets;
    }

    @Override
    public String getActionChangeDescription() {
        return TRANSLATOR.getTranslation("Replace_action_tooltip");
    }

    @Override
    public String getPreviewChangeDescription() {
        return TRANSLATOR.getTranslation("Preview_replace_tooltip");
    }

    @Override
    protected FollowInstructionInteractor clone() throws CloneNotSupportedException {
        return (FollowInstructionInteractor)super.clone();
    }

    @Override
    public void setAiInitialSuggestion(String initialSuggestion, int startOffset, int endOffset) throws BadLocationException {
        this.overwriteAiSuggestion(initialSuggestion, startOffset, endOffset);
    }

    @Override
    public void setAiInitialSuggestion(String initialSuggestion, Position startOffset, Position endOffset) {
        this.overwriteAiSuggestion(initialSuggestion, startOffset, endOffset);
    }
}

