/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.types;

import com.oxygenxml.positron.core.actions.types.BaseActionInteractor;
import com.oxygenxml.positron.core.interactions.IDocumentCreator;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.AdditionalInfo;
import java.net.URL;
import java.util.Optional;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class CreateDocumentActionInteractor
extends BaseActionInteractor
implements Cloneable {
    private final IDocumentCreator documentCreator;

    public CreateDocumentActionInteractor(AIActionDetails details, IDocumentCreator documentCreator) {
        super(details);
        this.documentCreator = documentCreator;
    }

    @Override
    public void applyChangesToDocument(String response) {
        this.modifyDocument(response);
    }

    @Override
    public int[] modifyDocument(String response) {
        URL newDocumentUrl;
        String fileExtension = Optional.ofNullable(this.details.getAdditionalInfo()).map(AdditionalInfo::getProperties).map(t -> (String)t.get("file_extension")).orElse("xml");
        String contentType = Optional.ofNullable(PluginWorkspaceProvider.getPluginWorkspace()).map(PluginWorkspace::getUtilAccess).map(t -> t.getContentType("untitled." + fileExtension)).orElse("text/xml");
        if (this.documentCreator != null && (newDocumentUrl = this.documentCreator.createNewEditor(fileExtension, contentType, TextUtils.extractInsertionContentFromResponse(response, contentType))) != null && this.aiContentListener != null) {
            this.aiContentListener.aiContentApplied(newDocumentUrl.toExternalForm());
        }
        return null;
    }

    @Override
    protected void notifyAboutDocumentChanges(int[] insertedOffsets, String response) {
    }

    @Override
    public boolean canPreviewDocumentModifications() {
        return false;
    }

    @Override
    public boolean isOperationThatChangesThePageContent() {
        return false;
    }

    @Override
    public String getActionChangeType() {
        return Translator.getInstance().getTranslation("Create_document");
    }

    @Override
    public String getActionChangeDescription() {
        return Translator.getInstance().getTranslation("Create_document_description");
    }

    @Override
    public String getActionChangeIconPath() {
        return "/images/CreateDocument16.png";
    }

    @Override
    public boolean allowsExecutionRetargeting() {
        return false;
    }

    @Override
    protected CreateDocumentActionInteractor clone() throws CloneNotSupportedException {
        return (CreateDocumentActionInteractor)super.clone();
    }

    @Override
    public void setNewAISuggestion(String initialSuggestion) {
        if (this.completionInserter != null && this.completionInserter.getEditorLocation() != null && this.aiContentListener != null) {
            String docUrl = this.createContextualDummyUrl();
            if (PluginWorkspaceProvider.getPluginWorkspace() != null && PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess() != null && "text/xml".equals(PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().getContentType(this.completionInserter.getEditorLocation()))) {
                docUrl = this.completionInserter.getEditorLocation();
            }
            this.aiContentListener.aiCompleteDocumentReceived(docUrl, initialSuggestion);
        }
    }

    @Override
    public boolean canModifyDocument() {
        return this.initialSuggestion != null;
    }
}

