/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.types;

import com.oxygenxml.positron.core.actions.ActionInteractor;
import com.oxygenxml.positron.core.actions.ParamsExpander;
import com.oxygenxml.positron.core.actions.validation.AIContentEventListener;
import com.oxygenxml.positron.core.interactions.ContentInserter;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.utilities.action.ActionsUtil;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.OutputAction;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public abstract class BaseActionInteractor
implements ActionInteractor,
Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BaseActionInteractor.class.getName());
    protected static final Translator TRANSLATOR = Translator.getInstance();
    private static final String FALLBACK_DUMMY_URL = "file:///dummy-non-dita-document";
    protected AIActionDetails details;
    protected ContentInserter completionInserter;
    protected String initialSuggestion;
    protected Position beforeStartOffset;
    protected Position startOffset;
    protected Position endOffset;
    protected Position afterEndOffset;
    private boolean directlyPerformAction;
    protected AIContentEventListener aiContentListener;

    public BaseActionInteractor(AIActionDetails details) {
        this.details = details;
    }

    public void setAIContentEventListener(AIContentEventListener listener) {
        this.aiContentListener = listener;
    }

    public void setCompletionInserter(ContentInserter completionInserter) {
        this.completionInserter = completionInserter;
    }

    protected String createContextualDummyUrl() {
        String dummyResultURL = FALLBACK_DUMMY_URL;
        if (this.completionInserter != null) {
            URL projectRootUrl;
            String editorLocation = this.completionInserter.getEditorLocation();
            if (editorLocation != null && !editorLocation.isEmpty()) {
                try {
                    URL editorUrl = new URL(editorLocation);
                    String fileName = URLUtil.extractFileName((String)editorLocation);
                    if (fileName != null && !fileName.isEmpty()) {
                        String baseName = fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(46)) : fileName;
                        String dummyFileName = baseName + "-ai-context.xml";
                        URL dummyUrl = new URL(editorUrl, dummyFileName);
                        dummyResultURL = dummyUrl.toExternalForm();
                    }
                }
                catch (MalformedURLException editorUrl) {
                    // empty catch block
                }
            }
            if (dummyResultURL.equals(FALLBACK_DUMMY_URL) && (projectRootUrl = this.completionInserter.getProjectRootURL()) != null) {
                try {
                    URL dummyUrl = new URL(projectRootUrl, "ai-context-document.xml");
                    dummyResultURL = dummyUrl.toExternalForm();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return dummyResultURL;
    }

    public void setNewAISuggestion(String initialSuggestion) {
        if (this.completionInserter != null && this.completionInserter.getEditorLocation() != null && this.aiContentListener != null) {
            String docUrl = this.createContextualDummyUrl();
            if (PluginWorkspaceProvider.getPluginWorkspace() != null && PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess() != null && "text/xml".equals(PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().getContentType(this.completionInserter.getEditorLocation()))) {
                docUrl = this.completionInserter.getEditorLocation();
            }
            this.aiContentListener.aiResponseReceived(docUrl, initialSuggestion);
        }
    }

    public void setAiInitialSuggestion(String initialSuggestion, Position startOffset, Position endOffset) {
        this.overwriteAiSuggestion(initialSuggestion, startOffset, endOffset);
    }

    public void setAiInitialSuggestion(String initialSuggestion, int startOffset, int endOffset) throws BadLocationException {
        this.overwriteAiSuggestion(initialSuggestion, this.completionInserter != null ? this.completionInserter.createPosition(startOffset) : null, this.completionInserter != null ? this.completionInserter.createPosition(endOffset) : null);
    }

    public void overwriteAiSuggestion(String initialSuggestion, int startOffset, int endOffset) throws BadLocationException {
        this.overwriteAiSuggestion(initialSuggestion, this.completionInserter != null ? this.completionInserter.createPosition(startOffset) : null, this.completionInserter != null ? this.completionInserter.createPosition(endOffset) : null);
    }

    public void overwriteAiSuggestion(String initialSuggestion, Position startOffset, Position endOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        try {
            if (startOffset != null) {
                Position position = this.beforeStartOffset = this.completionInserter != null ? this.completionInserter.createPosition(startOffset.getOffset() - 1) : null;
            }
            if (endOffset != null) {
                this.afterEndOffset = this.completionInserter != null ? this.completionInserter.createPosition(endOffset.getOffset() + 1) : null;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.initialSuggestion = initialSuggestion;
    }

    public Map<String, String> getExpandedActionParams() {
        return ParamsExpander.expandParams(this.details.getId(), this.details.getExpandParams(), this.completionInserter);
    }

    public boolean isOperationThatChangesThePageContent() {
        return true;
    }

    public AIActionDetails getActionDetails() {
        return this.details;
    }

    public void setActionDetails(AIActionDetails details) {
        this.details = details;
    }

    @Override
    public boolean canModifyDocument() {
        return this.getActionChangeType() != null && this.completionInserter != null && this.initialSuggestion != null;
    }

    @Override
    public boolean canPreviewDocumentModifications() {
        return !this.directlyPerformAction && this.canModifyDocument();
    }

    @Override
    public void applyChangesToDocument(String response) {
        if (this.completionInserter == null) {
            LOGGER.warn("Cannot apply changes to document: completionInserter is null. Action may have been interrupted by editor switch.");
            return;
        }
        int[] insertedOffsets = this.modifyDocument(response);
        this.notifyAboutDocumentChanges(insertedOffsets, response);
    }

    protected void notifyAboutDocumentChanges(int[] insertedOffsets, String response) {
        String url;
        if (this.aiContentListener != null && this.completionInserter != null && (url = this.completionInserter.getEditorLocation()) != null) {
            if (insertedOffsets != null && insertedOffsets[0] >= 0 && insertedOffsets[1] >= 0) {
                this.aiContentListener.aiContentApplied(url, insertedOffsets[0], insertedOffsets[1], response);
            } else {
                int[] offsets = this.getUpdatedStartAndEndOffsets();
                this.aiContentListener.aiContentApplied(url, offsets[0], offsets[1], response);
            }
        }
    }

    public abstract int[] modifyDocument(String var1);

    @Override
    public void previewDocumentModifications(String response) {
    }

    @Override
    public String getActionChangeType() {
        return null;
    }

    @Override
    public String getActionChangeDescription() {
        return TRANSLATOR.getTranslation("Perform_action_tooltip");
    }

    @Override
    public String getPreviewChangeDescription() {
        return TRANSLATOR.getTranslation("Preview_changes_tooltip");
    }

    @Override
    public String getActionChangeIconPath() {
        return null;
    }

    protected BaseActionInteractor clone() throws CloneNotSupportedException {
        try {
            BaseActionInteractor clone = (BaseActionInteractor)super.clone();
            clone.details = (AIActionDetails)ActionsUtil.cloneJSONSerializableObject((Object)this.details, AIActionDetails.class);
            return clone;
        }
        catch (IOException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    public void setDirectlyPerformAction(boolean directlyPerformAction) {
        this.directlyPerformAction = directlyPerformAction;
    }

    public int[] getUpdatedStartAndEndOffsets() {
        int eo;
        int so;
        int end;
        if (this.completionInserter != null && this.isInsertAction()) {
            int currentStart = this.completionInserter.getSelectionStart();
            int currentEnd = this.completionInserter.getSelectionEnd();
            if (currentStart >= 0 && currentEnd >= 0) {
                return new int[]{currentStart, currentEnd};
            }
        }
        int start = this.startOffset != null ? this.startOffset.getOffset() : -1;
        int n = end = this.endOffset != null ? this.endOffset.getOffset() : -1;
        if (start == end && this.beforeStartOffset != null && this.afterEndOffset != null && (so = this.beforeStartOffset.getOffset() + 1) != (eo = this.afterEndOffset.getOffset() - 1) && so > 0 && eo > 0) {
            start = so;
            end = eo;
        }
        if (this.completionInserter != null && start == end && this.fallbackOffsetsComputationOnSelection()) {
            int ss = this.completionInserter.getSelectionStart();
            int se = this.completionInserter.getSelectionEnd();
            if (ss >= 0 && se >= 0 && ss != se) {
                start = ss;
                end = se;
            }
        }
        return new int[]{start, end};
    }

    private boolean isInsertAction() {
        return this.details != null && this.details.getOutputAction() == OutputAction.INSERT;
    }

    protected boolean fallbackOffsetsComputationOnSelection() {
        return true;
    }

    @Override
    public boolean isDirectlyPerformAction() {
        return this.directlyPerformAction;
    }

    public String getInitialSuggestion() {
        return this.initialSuggestion;
    }

    public void transferContentInserterAndListenerTo(BaseActionInteractor newActionInteractor) {
        newActionInteractor.setCompletionInserter(this.completionInserter);
        newActionInteractor.setAIContentEventListener(this.aiContentListener);
    }
}

