/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.types;

import com.oxygenxml.positron.core.actions.types.AIAutocompletionEditorTypesEntryTablePO;
import com.oxygenxml.positron.core.actions.types.AIAutocompletionInterface;
import com.oxygenxml.positron.core.actions.types.AIAutocompletionUtil;
import com.oxygenxml.positron.core.actions.types.GenericAIAutocompletion;
import com.oxygenxml.positron.core.actions.types.JSONSchemaAIAutocompletion;
import com.oxygenxml.positron.core.actions.types.SchematronAIAutocompletion;
import com.oxygenxml.positron.core.actions.types.XsdAIAutocompletion;
import com.oxygenxml.positron.core.actions.types.XsltAIAutocompletion;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;

public final class AIAutocompletionProvider {
    private static final Logger log = LoggerFactory.getLogger(AIAutocompletionProvider.class);
    private static final String ENABLED_AI_AUTOCOMPLETION_EDITORS_OPTION = "oxygen.positron.plugin.enabled.ai.autocompletion.editors.types";
    private static final List<AIAutocompletionInterface> ALL_IMPLEMENTATIONS = List.of(new SchematronAIAutocompletion(), new XsltAIAutocompletion(), new XsdAIAutocompletion(), new JSONSchemaAIAutocompletion(), new GenericAIAutocompletion());
    private static final String EDITOR = "Editor";
    private static final Map<String, String> EDITOR_TYPES_MAP = AIAutocompletionUtil.ALL_EDITOR_TYPES;

    public static AIAutocompletionInterface getImplementation(String contentType) {
        return ALL_IMPLEMENTATIONS.stream().filter(impl -> impl.supportsContentType(contentType)).findFirst().orElse(null);
    }

    public static String getActionId(String contentType) {
        AIAutocompletionInterface implementation = AIAutocompletionProvider.getImplementation(contentType);
        return implementation != null ? implementation.getActionId() : null;
    }

    public static String processSuggestion(String suggestion, WSTextEditorPage editorPage, String contentType) {
        AIAutocompletionInterface implementation = AIAutocompletionProvider.getImplementation(contentType);
        if (implementation != null) {
            return implementation.processSuggestion(suggestion, editorPage);
        }
        return suggestion;
    }

    public static List<AIAutocompletionInterface> getAllImplementations() {
        return ALL_IMPLEMENTATIONS;
    }

    public static List<String> getAllSupportedContentTypes() {
        return ALL_IMPLEMENTATIONS.stream().flatMap(impl -> impl.getSupportedEditorTypes().stream()).collect(Collectors.toList());
    }

    public static boolean isActionEnabled(String contentType) {
        AIAutocompletionEditorTypesEntryTablePO contentTypePO = (AIAutocompletionEditorTypesEntryTablePO)PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getPersistentObjectOption(ENABLED_AI_AUTOCOMPLETION_EDITORS_OPTION, (ExternalPersistentObject)new AIAutocompletionEditorTypesEntryTablePO());
        return contentTypePO.isContentTypeActive(contentType);
    }

    public static String getEditorNameForContentType(String contentType) {
        return EDITOR_TYPES_MAP.getOrDefault(contentType, contentType + " Editor");
    }

    private AIAutocompletionProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

