/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions;

import com.oxygenxml.positron.core.util.AddonActionsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ExcludedPositronActions {
    private List<String> actionIDs;
    private List<String> extraIDsToExclude;

    public ExcludedPositronActions(String actionIdsAsText, boolean includeAddonContributedExclusions, Map<String, Object> applicationContext) {
        String[] splitIDs = actionIdsAsText.split(",");
        this.actionIDs = Arrays.stream(splitIDs).map(String::strip).filter(s -> !s.isBlank()).collect(Collectors.toCollection(ArrayList::new));
        if (includeAddonContributedExclusions) {
            this.extraIDsToExclude = AddonActionsUtil.getExternalAIActionIDsToExclude(applicationContext);
        }
    }

    public boolean isExcludedAction(String actionID) {
        return this.actionIDs.contains(actionID) || this.extraIDsToExclude != null && this.extraIDsToExclude.contains(actionID);
    }

    public void addActionID(String actionID) {
        this.actionIDs.add(actionID);
    }

    public void removeActionID(String actionID) {
        this.actionIDs.remove(actionID);
    }

    public String serializeIDsOfExcludedActions() {
        StringBuilder sb = new StringBuilder();
        int size = this.actionIDs.size();
        for (int i = 0; i < size; ++i) {
            sb.append(this.actionIDs.get(i));
            if (i >= size - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public List<String> getExcludedActionsIDs() {
        return this.actionIDs;
    }
}

