/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions;

import com.oxygenxml.positron.core.actions.types.BaseActionInteractor;
import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.interactions.ContextInfo;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.InputContext;
import java.io.Reader;
import java.util.Optional;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultActionInteractor
extends BaseActionInteractor
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(DefaultActionInteractor.class);
    protected DocumentContentInteractor documentExtractor;

    public DefaultActionInteractor(AIActionDetails details) {
        super(details);
    }

    @Override
    public String getActionChangeType() {
        return Translator.getInstance().getTranslation("Insert");
    }

    @Override
    public boolean canModifyDocument() {
        int[] offsets = this.getUpdatedStartAndEndOffsets();
        return this.isDocumentOpened() && (this.documentExtractor != null || offsets[0] != -1 && offsets[1] != -1);
    }

    @Override
    public boolean canPreviewDocumentModifications() {
        return this.canModifyDocument();
    }

    @Override
    public void previewDocumentModifications(String response) {
        try {
            int[] offsets = this.computeStartEndOffsets();
            response = TextUtils.extractInsertionContentFromResponse(response, this.getContentType());
            this.completionInserter.previewInsert(offsets[0], offsets[1], response, null, true, true);
        }
        catch (OperationCancelledByAiIgnoreException | BadLocationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int[] modifyDocument(String response) {
        try {
            int[] offsets = this.computeStartEndOffsets();
            response = TextUtils.extractInsertionContentFromResponse(response, this.getContentType());
            return this.completionInserter.insert(offsets[0], offsets[1], response, null, true, true, false);
        }
        catch (OperationCancelledByAiIgnoreException | BadLocationException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private int[] computeStartEndOffsets() throws BadLocationException, OperationCancelledByAiIgnoreException {
        int[] nArray;
        if (this.documentExtractor == null) {
            return this.getUpdatedStartAndEndOffsets();
        }
        ContextInfo ctxt = this.documentExtractor.getCurrentContextInfo(true, InputContext.SELECTION, true);
        int caretOffset = this.documentExtractor.getCaretOffset();
        if (ctxt != null && !ctxt.isEmpty()) {
            int[] nArray2 = new int[2];
            nArray2[0] = ctxt.getStartOffset();
            nArray = nArray2;
            nArray2[1] = ctxt.getEndOffset();
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = caretOffset;
            nArray = nArray3;
            nArray3[1] = caretOffset;
        }
        return nArray;
    }

    @Override
    public String getActionChangeDescription() {
        return Translator.getInstance().getTranslation("Insert_response_at_caret_position");
    }

    @Override
    public String getPreviewChangeDescription() {
        return Translator.getInstance().getTranslation("Preview_insert_response_at_caret_position");
    }

    @Override
    public String getActionChangeIconPath() {
        return "/images/InsertAIResponse16.png";
    }

    public String getSelectedContent(boolean updateSelectionIfNeeded) throws BadLocationException, OperationCancelledByAiIgnoreException {
        String selContent = null;
        if (this.documentExtractor != null) {
            ContextInfo ci = this.documentExtractor.getCurrentContextInfo(true, InputContext.SELECTION, updateSelectionIfNeeded);
            selContent = ci != null && !ci.isEmpty() ? ci.getUsableContent() : null;
        }
        return selContent;
    }

    public void setDocumentExtractor(DocumentContentInteractor documentExtractor) {
        this.documentExtractor = documentExtractor;
    }

    public boolean isDocumentOpened() {
        return this.completionInserter != null;
    }

    public String getEntireDocumentContent() {
        return this.completionInserter.getEntireDocumentContent();
    }

    @Override
    protected DefaultActionInteractor clone() throws CloneNotSupportedException {
        return (DefaultActionInteractor)super.clone();
    }

    public Reader createDocumentReader() {
        return this.completionInserter.createDocumentReader();
    }

    public String getDocumentLocation() {
        return this.completionInserter.getEditorLocation();
    }

    public String getContentType() {
        Optional<String> ctOptional;
        if (this.completionInserter != null && (ctOptional = this.completionInserter.getContentType()).isPresent()) {
            return ctOptional.get();
        }
        return null;
    }

    public int getSelectionStart() {
        return this.completionInserter.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.completionInserter.getSelectionEnd();
    }
}

