/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeUIExecutor {
    private static final Logger log = LoggerFactory.getLogger(SafeUIExecutor.class);
    private static SafeUIExecutor INSTANCE = null;

    protected SafeUIExecutor() {
    }

    public static void setInstance(SafeUIExecutor instance) {
        INSTANCE = instance;
    }

    public static SafeUIExecutor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SafeUIExecutor();
        }
        return INSTANCE;
    }

    public void syncExec(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException | InvocationTargetException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void asyncExec(Runnable r) {
        SwingUtilities.invokeLater(r);
    }
}

