/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core;

import com.azure.core.http.ProxyOptions;
import com.azure.core.util.HttpClientOptions;
import com.oxygenxml.positron.connector.api.HttpClientExtraConfigProvider;
import com.oxygenxml.positron.core.auth.FakeX509TrustManager;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyConnectionInfo;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;

public class OxyHttpClientExtraConfigProvider
implements HttpClientExtraConfigProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)OxyHttpClientExtraConfigProvider.class.getName());
    private ProxyDetailsProvider proxyProvider;

    public OxyHttpClientExtraConfigProvider(ProxyDetailsProvider proxyDetailsProvider) {
        this.proxyProvider = proxyDetailsProvider;
    }

    @Override
    public OkHttpClient.Builder configureHttpClientAccordingToPreferences(OkHttpClient.Builder builder, String url) {
        builder = this.configureProxyAccordingToPreferences(builder, url);
        return this.configureSslAccordingToPreferences(builder);
    }

    private OkHttpClient.Builder configureProxyAccordingToPreferences(OkHttpClient.Builder builder, String url) {
        ProxyConnectionInfo proxyInfo;
        Proxy proxy = null;
        if (this.proxyProvider != null && (proxyInfo = this.proxyProvider.getProxyConnectionInfo(URLUtil.convertToURL((String)url))) != null) {
            try {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(InetAddress.getByName(proxyInfo.getHost()), proxyInfo.getPort()));
            }
            catch (UnknownHostException e) {
                LOGGER.debug((Object)e, (Throwable)e);
            }
        }
        if (proxy != null) {
            builder = builder.proxy(proxy);
        }
        return builder;
    }

    private OkHttpClient.Builder configureSslAccordingToPreferences(OkHttpClient.Builder builder) {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWorkspace != null) {
            boolean allowCerts;
            Object allowAllCerts = pluginWorkspace.getGlobalObjectProperty("automatically.accept.certificates");
            boolean bl = allowCerts = allowAllCerts != null && allowAllCerts instanceof Boolean && (Boolean)allowAllCerts != false;
            if (allowCerts) {
                try {
                    FakeX509TrustManager fakeX509TrustManager = new FakeX509TrustManager();
                    SSLContext sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(null, new TrustManager[]{fakeX509TrustManager}, null);
                    SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                    builder = builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)fakeX509TrustManager);
                    builder.setHostnameVerifier$okhttp((hostname, session) -> true);
                }
                catch (Exception e) {
                    LOGGER.error((Object)e, (Throwable)e);
                }
            }
        }
        return builder;
    }

    @Override
    public HttpClientOptions configureHttpClientAccordingToPreferences(HttpClientOptions httpOptions, String url) {
        ProxyConnectionInfo proxyInfo;
        if (this.proxyProvider != null && (proxyInfo = this.proxyProvider.getProxyConnectionInfo(URLUtil.convertToURL((String)url))) != null) {
            try {
                httpOptions.setProxyOptions(new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(InetAddress.getByName(proxyInfo.getHost()), proxyInfo.getPort())));
            }
            catch (UnknownHostException e) {
                LOGGER.debug((Object)e, (Throwable)e);
            }
        }
        return httpOptions;
    }
}

