/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core;

import com.oxygenxml.positron.core.InappropriateCompletionException;
import com.oxygenxml.positron.core.IncompleteCompletionException;
import com.oxygenxml.positron.core.RefusalCompletionException;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.service.PositronErrorsUtil;
import java.util.Collections;
import java.util.Map;

public interface AiCompletionErrorInfoProvider {
    default public Map<String, String> computeErrorLink(Throwable exception) {
        return Collections.emptyMap();
    }

    default public String getHumanReadableErrorMessageToPresent(Throwable t) {
        StringBuilder message = new StringBuilder();
        if (!PositronErrorsUtil.isStoppedByUser(t) && !(t instanceof InterruptedException)) {
            if (t instanceof InappropriateCompletionException) {
                message.append(Translator.getInstance().getTranslation("Resulted_content_inappropriate"));
            } else if (t instanceof RefusalCompletionException) {
                message.append(Translator.getInstance().getTranslation("Resulted_content_refused"));
            } else if (t instanceof IncompleteCompletionException) {
                message.append(Translator.getInstance().getTranslation("Incomplete_response"));
            } else {
                message.append(t.getMessage());
            }
        }
        return message.toString();
    }
}

