/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core;

import com.oxygenxml.positron.api.connector.AIConnectionException;
import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.SpeechToTextRequest;
import com.oxygenxml.positron.connector.util.ReactiveUtil;
import com.oxygenxml.positron.core.AICompletionResponse;
import com.oxygenxml.positron.core.AICompletionStreamResponse;
import com.oxygenxml.positron.core.AiCompletionErrorInfoProvider;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.InvalidUserConfigurationException;
import com.oxygenxml.positron.core.MessageDelayedEditorVariablesExpander;
import com.oxygenxml.positron.core.actions.loader.AdditionalActionsProvider;
import com.oxygenxml.positron.core.api.CompletionResponseUtil;
import com.oxygenxml.positron.core.tools.ToolsExecutionCapability;
import com.oxygenxml.positron.core.util.TranslateActionsUtil;
import com.oxygenxml.positron.utilities.exceptions.InvalidMessageException;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ro.sync.basic.execution.StoppedByUserException;

public abstract class AICompletionDetailsProvider
extends ToolsExecutionCapability
implements AiCompletionErrorInfoProvider,
MessageDelayedEditorVariablesExpander {
    private static final String BUILTIN_ACTIONS_DIR = "/oxygen-ai-positron-utilities-actions";

    public List<AIActionDetails> loadBuiltInActions() {
        ArrayList<AIActionDetails> actionDetails = new ArrayList<AIActionDetails>();
        URL builtinActionDirURL = this.getClass().getResource(BUILTIN_ACTIONS_DIR);
        if (builtinActionDirURL != null) {
            final URL finalBuiltinActionDirURL = this.resolve(builtinActionDirURL);
            AdditionalActionsProvider additionalActionsProvider = new AdditionalActionsProvider(){

                @Override
                protected URL getAdditionalActionsFolder() {
                    return finalBuiltinActionDirURL;
                }
            };
            actionDetails.addAll(additionalActionsProvider.getActions());
        }
        actionDetails.forEach(a -> {
            a.setBuiltinAction(true);
            TranslateActionsUtil.translate(a);
        });
        return actionDetails;
    }

    public URL resolve(URL url) {
        return url;
    }

    public AICompletionResponse executeAction(AIActionDetails action, List<Message> messages, Map<String, String> parameters) throws CannotComputeCompletionDetailsException, InvalidMessageException, StoppedByUserException {
        AICompletionStreamResponse incrementalStreamResponse = this.executeActionIncremental(action, messages, parameters);
        CompletionResponse capturedResponse = null;
        try {
            capturedResponse = ReactiveUtil.captureChunks(incrementalStreamResponse.getResponseContent());
        }
        catch (AIConnectionException e) {
            throw new InvalidUserConfigurationException(e.getMessage(), (Exception)((Object)e));
        }
        catch (CannotComputeCompletionDetailsException | InvalidMessageException | StoppedByUserException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CannotComputeCompletionDetailsException(e.getMessage(), e);
        }
        AICompletionResponse aiResponse = new AICompletionResponse();
        aiResponse.setResponseContent(CompletionResponseUtil.getCompletion(capturedResponse));
        aiResponse.setShouldBeStructuredResponse(incrementalStreamResponse.isShouldBeStructuredResponse());
        return aiResponse;
    }

    public abstract AICompletionStreamResponse executeActionIncremental(AIActionDetails var1, List<Message> var2, Map<String, String> var3) throws CannotComputeCompletionDetailsException, InvalidMessageException;

    public boolean isEnabledSpeechToText() {
        return false;
    }

    public String convertSpeechToText(SpeechToTextRequest speechRequest) throws AIConnectionException {
        throw new AIConnectionException("Speech to text not available");
    }
}

