/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.oxygenxml.positron.api.connector.AIConnectionException;
import com.oxygenxml.positron.connector.util.ReactiveUtil;
import com.oxygenxml.positron.core.InvalidUserConfigurationException;
import com.oxygenxml.positron.core.api.SSE;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.debug.LoggerUtil;
import io.reactivex.rxjava3.core.FlowableEmitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.SubmissionPublisher;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;

public class ResponseBodyCallback<T>
implements Callback<ResponseBody> {
    private static final Logger log = LoggerFactory.getLogger(ResponseBodyCallback.class);
    private FlowableEmitter<T> emitter;
    private SubmissionPublisher<T> submissionPublisher;
    private Class<T> dataType;

    public ResponseBodyCallback(SubmissionPublisher<T> submissionPublisher, Class<T> dataType) {
        this.submissionPublisher = submissionPublisher;
        this.dataType = dataType;
    }

    public ResponseBodyCallback(FlowableEmitter<T> emitter, Class<T> dataType) {
        this.emitter = emitter;
        this.dataType = dataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
        BufferedReader reader = null;
        if (log.isDebugEnabled()) {
            log.debug("<-- Received response;\n\t Code: {};", (Object)response.code());
        }
        try {
            boolean hasContentThatIsNotSSE;
            String line;
            if (!response.isSuccessful()) {
                HttpException httpException = new HttpException(response);
                AIConnectionException processHttpException = ReactiveUtil.processHttpException(httpException);
                String errorMesssage = processHttpException.getMessage();
                if (log.isDebugEnabled()) {
                    log.debug("\n\tExceptions message is: " + errorMesssage);
                    StringBuilder headersString = new StringBuilder();
                    response.headers().forEach(p -> {
                        headersString.append("\n");
                        headersString.append((String)p.component1()).append(":").append((String)p.component2());
                    });
                    log.debug("\n\t Response headers: {} ", (Object)headersString.toString());
                }
                if (ReactiveUtil.isInvalidOpenAiApiKey(processHttpException.getErrorCode(), response.code())) {
                    errorMesssage = "Incorrect API key provided. You can find your API key at https://platform.openai.com/account/api-keys";
                }
                throw new InvalidUserConfigurationException(errorMesssage, (Exception)((Object)processHttpException));
            }
            InputStream in = ((ResponseBody)response.body()).byteStream();
            reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            SSE sse = null;
            StringBuilder nonSSEContent = new StringBuilder();
            boolean isSEE = false;
            while (!this.isPublisherCancelled() && (line = reader.readLine()) != null) {
                log.debug("line: {}", (Object)line);
                if (line.startsWith("event:")) continue;
                if (line.startsWith("data:")) {
                    isSEE = true;
                    String data = line.substring(5).trim();
                    sse = new SSE(data);
                    continue;
                }
                if (!line.isEmpty() && sse == null && !isSEE) {
                    nonSSEContent.append(line);
                    continue;
                }
                if (line.equals("") && sse != null) {
                    if (sse.isDone()) break;
                    this.submit(sse);
                    sse = null;
                    continue;
                }
                this.throwInvalidSeeFormat(line);
            }
            String nonSseResponse = nonSSEContent.toString();
            boolean bl = hasContentThatIsNotSSE = !isSEE && !nonSseResponse.isEmpty();
            if (hasContentThatIsNotSSE) {
                try {
                    AIRequestUtil.defaultObjectMapper().readValue(nonSseResponse, this.dataType);
                    if (log.isDebugEnabled()) {
                        log.debug("Expected to receive SSE. Response is valid, but it's not SSE: " + nonSseResponse);
                    }
                    this.submit(new SSE(nonSseResponse));
                }
                catch (JsonProcessingException e) {
                    log.debug(e.getMessage(), (Throwable)e);
                    this.throwInvalidSeeFormat(nonSseResponse);
                }
            }
            if (this.emitter != null) {
                this.emitter.onComplete();
            } else {
                this.submissionPublisher.close();
            }
        }
        catch (Throwable t) {
            this.onFailure(call, t);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException in) {}
            }
        }
    }

    private void throwInvalidSeeFormat(String line) throws InvalidUserConfigurationException {
        AIConnectionException aiConnectionException = new AIConnectionException("Invalid sse format! " + line, "500", null);
        throw new InvalidUserConfigurationException(aiConnectionException.getMessage(), (Exception)((Object)aiConnectionException));
    }

    private void submit(SSE item) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("SSE: " + LoggerUtil.filterMessagesFromRequestBody((String)item.getData()));
            }
            Object chunkItem = AIRequestUtil.defaultObjectMapper().readValue(item.getData(), this.dataType);
            if (this.emitter != null) {
                this.emitter.onNext(chunkItem);
            } else {
                this.submissionPublisher.submit(chunkItem);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e, (Throwable)e);
            }
            this.submitError(e);
        }
    }

    private boolean isPublisherCancelled() {
        return this.emitter != null && this.emitter.isCancelled() || this.submissionPublisher != null && this.submissionPublisher.isClosed();
    }

    public void onFailure(Call<ResponseBody> call, Throwable t) {
        this.submitError(t);
    }

    private void submitError(Throwable t) {
        if (this.emitter != null) {
            this.emitter.onError(t);
        } else {
            this.submissionPublisher.closeExceptionally(t);
        }
    }
}

