/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.api.connector.AIConnectionException;
import com.oxygenxml.positron.api.connector.dto.CompletionChoice;
import com.oxygenxml.positron.api.connector.dto.CompletionChunk;
import com.oxygenxml.positron.api.connector.dto.CompletionMessage;
import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.connector.util.ResponseBodyCallback;
import com.oxygenxml.positron.core.api.AIError;
import com.oxygenxml.positron.core.api.CompletionResponseUtil;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableEmitter;
import io.reactivex.rxjava3.core.FlowableOnSubscribe;
import io.reactivex.rxjava3.core.Single;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import java.util.function.Function;
import okhttp3.ResponseBody;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.HttpException;
import ro.sync.basic.execution.StoppedByUserException;

public class ReactiveUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ReactiveUtil.class.getName());
    private static ObjectMapper mapper = AIRequestUtil.defaultObjectMapper();

    private ReactiveUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static <T> Flowable<T> translateFlowToFlowable(Flow.Publisher<T> flowPublisher) {
        Publisher publisher = FlowAdapters.toPublisher(flowPublisher);
        return Flowable.fromPublisher((Publisher)publisher);
    }

    public static <T> Flow.Publisher<T> streamFlow(Call<ResponseBody> apiCall, Class<T> cl) {
        SubmissionPublisher submissionPublisher = new SubmissionPublisher(Executors.newFixedThreadPool(1), Flow.defaultBufferSize());
        apiCall.enqueue(new ResponseBodyCallback(submissionPublisher, cl));
        return submissionPublisher;
    }

    public static <T> Flowable<T> stream(final Call<ResponseBody> apiCall, final Class<T> cl) {
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<T>(){

            public void subscribe(@NonNull @NonNull FlowableEmitter<@NonNull T> emitter) throws Throwable {
                apiCall.enqueue(new ResponseBodyCallback(emitter, cl));
            }
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    public static <T> T execute(Single<T> apiCall) throws AIConnectionException {
        try {
            return (T)apiCall.blockingGet();
        }
        catch (HttpException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)e, (Throwable)e);
            }
            AIConnectionException aiException = ReactiveUtil.processHttpException(e);
            throw aiException;
        }
        catch (RuntimeException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)e, (Throwable)e);
            }
            Throwable throwable = e;
            if (e.getCause() != null) {
                throwable = e.getCause();
            }
            if (throwable instanceof InterruptedIOException || throwable instanceof InterruptedException) {
                StoppedByUserException stoppedByUserException = new StoppedByUserException();
                throw new AIConnectionException(stoppedByUserException.getMessage(), null, (Exception)((Object)stoppedByUserException));
            }
            throw new AIConnectionException(throwable.getMessage(), null, (Exception)e);
        }
    }

    public static <T, R> Flow.Publisher<R> map(final Flow.Publisher<T> source, final Function<T, R> mapper) {
        return new Flow.Publisher<R>(){

            @Override
            public void subscribe(final Flow.Subscriber<? super R> subscriber) {
                source.subscribe(new Flow.Subscriber<T>(){
                    private Flow.Subscription subscription;

                    @Override
                    public void onSubscribe(Flow.Subscription subscription) {
                        this.subscription = subscription;
                        subscriber.onSubscribe(subscription);
                    }

                    @Override
                    public void onNext(T item) {
                        try {
                            Object mappedItem = mapper.apply(item);
                            subscriber.onNext(mappedItem);
                        }
                        catch (Exception e) {
                            subscriber.onError(e);
                        }
                    }

                    @Override
                    public void onError(Throwable throwable) {
                        subscriber.onError(throwable);
                    }

                    @Override
                    public void onComplete() {
                        subscriber.onComplete();
                    }
                });
            }
        };
    }

    public static AIConnectionException processHttpException(HttpException e) {
        AIConnectionException aiException;
        block9: {
            aiException = new AIConnectionException(e.getMessage(), String.valueOf(e.code()), (Exception)((Object)e));
            if (e.response() != null && e.response().errorBody() != null) {
                try {
                    String errorBody = e.response().errorBody().string();
                    if (errorBody.isEmpty()) break block9;
                    aiException = new AIConnectionException(e.getMessage() + ": " + errorBody, String.valueOf(e.code()), (Exception)((Object)e));
                    try {
                        AIError error = (AIError)mapper.readValue(errorBody, AIError.class);
                        Optional<String> errorMessage = error.getErrorMessage();
                        if (errorMessage.isPresent()) {
                            aiException = new AIConnectionException(errorMessage.get(), (String)error.getErrorCode().orElse(null), (Exception)((Object)e));
                        }
                    }
                    catch (JsonProcessingException singleErrorEx) {
                        AIError[] errors = (AIError[])mapper.readValue(errorBody, AIError[].class);
                        if (errors.length > 0) {
                            Object mergedMessages = "";
                            for (AIError aiError : errors) {
                                if (!aiError.getErrorMessage().isPresent()) continue;
                                mergedMessages = (String)mergedMessages + aiError.getErrorMessage() + "; ";
                            }
                            if (!((String)mergedMessages).isEmpty()) {
                                String firstErrorCode = errors[0].getErrorCode().orElse(null);
                                aiException = new AIConnectionException((String)mergedMessages, firstErrorCode, (Exception)((Object)e));
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return aiException;
    }

    public static boolean isInvalidOpenAiApiKey(String customErrorCode, int httpErrorCode) {
        return httpErrorCode == 401 && (customErrorCode == null || "invalid_api_key".equals(customErrorCode));
    }

    public static CompletionResponse captureChunks(Flowable<CompletionChunk> flowable) throws Exception {
        StringBuilder aiCompletionBuilder = new StringBuilder();
        Exception[] ex = new Exception[1];
        ArrayList toolCalls = new ArrayList();
        flowable.blockingSubscribe(chunk -> {
            String content = CompletionResponseUtil.getCompletion((CompletionResponse)chunk);
            if (CompletionResponseUtil.hasToolCalls((CompletionResponse)chunk)) {
                toolCalls.addAll(CompletionResponseUtil.getToolCalls((CompletionResponse)chunk));
            }
            if (content != null) {
                aiCompletionBuilder.append(content);
            }
        }, t -> {
            if (t instanceof InterruptedException) {
                ex[0] = new StoppedByUserException();
                Thread.currentThread().interrupt();
            } else {
                ex[0] = (Exception)t;
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        CompletionResponse response = new CompletionResponse();
        CompletionChoice completionChoice = new CompletionChoice();
        CompletionMessage message = new CompletionMessage();
        message.setToolCalls(toolCalls);
        message.setContent(aiCompletionBuilder.toString());
        completionChoice.setMessage(message);
        response.setChoices(Arrays.asList(completionChoice));
        return response;
    }
}

