/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.openai;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.connector.api.HttpClientExtraConfigProvider;
import com.oxygenxml.positron.connector.openai.OpenAiApi;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public abstract class OpenAiAPIProvider {
    private OpenAiApi api = null;
    private HttpClientExtraConfigProvider httpClientExtraConfigProvider;
    private String baseUrl;
    private String apiKey;

    public OpenAiAPIProvider(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String baseUrl, String apiKey) {
        this.httpClientExtraConfigProvider = httpClientExtraConfigProvider;
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
    }

    public OpenAiApi getOpenAIApi() {
        if (this.api == null) {
            OkHttpClient client = this.createHttpClient(this.httpClientExtraConfigProvider, this.baseUrl, this.apiKey);
            final JacksonConverterFactory jacksonConverterFactory = JacksonConverterFactory.create((ObjectMapper)AIRequestUtil.defaultObjectMapper());
            Retrofit retrofit = new Retrofit.Builder().baseUrl(this.baseUrl).client(client).addConverterFactory(new Converter.Factory(){

                public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
                    return jacksonConverterFactory.requestBodyConverter(type, parameterAnnotations, methodAnnotations, retrofit);
                }

                public Converter<?, String> stringConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
                    return jacksonConverterFactory.stringConverter(type, annotations, retrofit);
                }

                public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
                    if (type == String.class) {
                        return ResponseBody::string;
                    }
                    return jacksonConverterFactory.responseBodyConverter(type, annotations, retrofit);
                }
            }).addCallAdapterFactory((CallAdapter.Factory)RxJava3CallAdapterFactory.create()).build();
            this.api = (OpenAiApi)retrofit.create(OpenAiApi.class);
        }
        return this.api;
    }

    public abstract OkHttpClient createHttpClient(HttpClientExtraConfigProvider var1, String var2, String var3);

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

