/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.openai;

import com.oxygenxml.positron.api.connector.AIConnectionException;
import com.oxygenxml.positron.api.connector.AIService;
import com.oxygenxml.positron.api.connector.dto.CompletionChunk;
import com.oxygenxml.positron.api.connector.dto.CompletionRequest;
import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.api.connector.dto.ModerationRequest;
import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.api.connector.dto.SpeechToTextRequest;
import com.oxygenxml.positron.connector.api.HttpClientExtraConfigProvider;
import com.oxygenxml.positron.connector.openai.HeadersQueryInterceptor;
import com.oxygenxml.positron.connector.openai.IHeadersProvider;
import com.oxygenxml.positron.connector.openai.OpenAiAPIProvider;
import com.oxygenxml.positron.connector.openai.RequestLoggingInterceptor;
import com.oxygenxml.positron.connector.util.AIServiceUtil;
import com.oxygenxml.positron.connector.util.ReactiveUtil;
import com.oxygenxml.positron.core.api.Moderation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAIService
implements AIService {
    private static final Logger log = LoggerFactory.getLogger(OpenAIService.class);
    private static final String DEFAULT_TRANSCRIBE_MODEL_NAME = "gpt-4o-transcribe";
    private String organization;
    private List<Pair<String, String>> extraHeaders;
    protected OpenAiAPIProvider apiProvider;
    private boolean shouldApplyModeration;
    private boolean shouldAllowSpeechToText;

    public OpenAIService(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String baseUrl, String apiKey, String organization, List<Pair<String, String>> extraHeaders, boolean shouldApplyModeration, boolean shouldAllowSpeechToText) {
        this.organization = organization;
        this.shouldApplyModeration = shouldApplyModeration;
        this.extraHeaders = extraHeaders;
        this.shouldAllowSpeechToText = shouldAllowSpeechToText;
        this.apiProvider = new OpenAiAPIProvider(httpClientExtraConfigProvider, baseUrl, apiKey){

            @Override
            public OkHttpClient createHttpClient(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String baseUrl, String token) {
                return OpenAIService.this.createServiceHttpClient(httpClientExtraConfigProvider, baseUrl, token);
            }
        };
    }

    public Flow.Publisher<CompletionChunk> getCompletionFlux(CompletionRequest completionRequest) {
        return ReactiveUtil.streamFlow(this.apiProvider.getOpenAIApi().createChatCompletionStream(completionRequest), CompletionChunk.class);
    }

    public CompletionResponse getCompletion(CompletionRequest completionRequest) throws AIConnectionException {
        return ReactiveUtil.execute(this.apiProvider.getOpenAIApi().createChatCompletion(completionRequest));
    }

    public boolean isRequiringApplyingModeration() {
        return this.shouldApplyModeration;
    }

    public boolean applyModeration(ModerationRequest moderationRequest) throws AIConnectionException {
        List<Moderation> results = ReactiveUtil.execute(this.apiProvider.getOpenAIApi().createModeration(moderationRequest)).getResults();
        return results != null && results.stream().anyMatch(Moderation::isFlagged);
    }

    protected OkHttpClient createServiceHttpClient(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String baseUrl, String token) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        if (token != null && !token.isBlank()) {
            headers.put("Authorization", "Bearer " + token);
        }
        if (this.organization != null && !this.organization.isEmpty()) {
            headers.put("OpenAI-Organization", this.organization);
        }
        return this.createHttpClient(httpClientExtraConfigProvider, baseUrl, () -> headers, null);
    }

    protected OkHttpClient createHttpClient(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String baseUrl, IHeadersProvider headersProvider, Map<String, String> queryParams) {
        OkHttpClient.Builder builder = httpClientExtraConfigProvider.configureHttpClientAccordingToPreferences(new OkHttpClient.Builder(), baseUrl).addInterceptor((Interceptor)new HeadersQueryInterceptor(() -> {
            HashMap<String, String> headers = new HashMap<String, String>(headersProvider.getHeaders());
            if (this.extraHeaders != null) {
                this.extraHeaders.forEach(p -> headers.put((String)p.getFirst(), (String)p.getSecond()));
            }
            return headers;
        }, queryParams));
        if (log.isDebugEnabled()) {
            builder = builder.addInterceptor((Interceptor)new RequestLoggingInterceptor(log));
        }
        return builder.connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout((long)AIServiceUtil.getAIClientReadTimeout(), TimeUnit.MILLISECONDS).build();
    }

    public boolean isEnabledSpeechToText() {
        return this.shouldAllowSpeechToText;
    }

    public String convertSpeechToText(SpeechToTextRequest speechRequest) throws AIConnectionException {
        RequestBody fileBody = RequestBody.create((byte[])speechRequest.getInput(), (MediaType)MediaType.parse((String)speechRequest.getMimeType()));
        MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)"recording", (RequestBody)fileBody);
        RequestBody model = RequestBody.create((String)DEFAULT_TRANSCRIBE_MODEL_NAME, (MediaType)MultipartBody.FORM);
        RequestBody responseFormat = RequestBody.create((String)"text", (MediaType)MultipartBody.FORM);
        String languageString = speechRequest.getLanguage();
        int minusIndex = languageString.indexOf(45);
        if (minusIndex != -1) {
            languageString = languageString.substring(0, minusIndex);
        }
        RequestBody language = RequestBody.create((String)languageString, (MediaType)MultipartBody.FORM);
        return ReactiveUtil.execute(this.apiProvider.getOpenAIApi().transcribeAudio(filePart, model, responseFormat, language));
    }

    void setApiProviderForTc(OpenAiAPIProvider apiProvider) {
        this.apiProvider = apiProvider;
    }

    public String getBaseUrl() {
        return this.apiProvider != null ? this.apiProvider.getBaseUrl() : null;
    }
}

